/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CherryPickResult;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jboss.forge.git.errors.CantMergeCommitWithZeroParentsException;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;

public abstract class GitUtils {
    public static Git clone(DirectoryResource dir, String repoUri) throws GitAPIException {
        CloneCommand clone = Git.cloneRepository().setURI(repoUri).setDirectory(dir.getUnderlyingResourceObject());
        Git git = clone.call();
        return git;
    }

    public static Git git(DirectoryResource dir) throws IOException {
        RepositoryBuilder db = (RepositoryBuilder)new RepositoryBuilder().findGitDir(dir.getUnderlyingResourceObject());
        return new Git(db.build());
    }

    public static Ref checkout(Git git, String remote, boolean createBranch, CreateBranchCommand.SetupUpstreamMode mode, boolean force) throws GitAPIException {
        CheckoutCommand checkout = git.checkout();
        checkout.setCreateBranch(createBranch);
        checkout.setName(remote);
        checkout.setForce(force);
        checkout.setUpstreamMode(mode);
        return checkout.call();
    }

    public static Ref checkout(Git git, Ref localRef, boolean createBranch, CreateBranchCommand.SetupUpstreamMode mode, boolean force) throws GitAPIException {
        CheckoutCommand checkout = git.checkout();
        checkout.setName(Repository.shortenRefName((String)localRef.getName()));
        checkout.setForce(force);
        checkout.setUpstreamMode(mode);
        return checkout.call();
    }

    public static FetchResult fetch(Git git, String remote, String refSpec, int timeout, boolean fsck, boolean dryRun, boolean thin, boolean prune) throws GitAPIException {
        FetchCommand fetch = git.fetch();
        fetch.setCheckFetchedObjects(fsck);
        fetch.setRemoveDeletedRefs(prune);
        if (refSpec != null) {
            fetch.setRefSpecs(new RefSpec[]{new RefSpec(refSpec)});
        }
        if (timeout >= 0) {
            fetch.setTimeout(timeout);
        }
        fetch.setDryRun(dryRun);
        fetch.setRemote(remote);
        fetch.setThin(thin);
        fetch.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
        FetchResult result = fetch.call();
        return result;
    }

    public static Git init(DirectoryResource dir) throws IOException {
        FileResource gitDir = (FileResource)dir.getChildDirectory(".git").reify(FileResource.class);
        gitDir.mkdirs();
        RepositoryBuilder db = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setGitDir(gitDir.getUnderlyingResourceObject())).setup();
        Git git = new Git(db.build());
        git.getRepository().create();
        return git;
    }

    public static PullResult pull(Git git, int timeout) throws GitAPIException {
        PullCommand pull = git.pull();
        if (timeout >= 0) {
            pull.setTimeout(timeout);
        }
        pull.setProgressMonitor((ProgressMonitor)new TextProgressMonitor());
        PullResult result = pull.call();
        return result;
    }

    public static List<Ref> getRemoteBranches(Git repo) throws GitAPIException {
        ArrayList<Ref> results = new ArrayList<Ref>();
        try {
            FetchResult fetch = repo.fetch().setRemote("origin").call();
            Collection refs = fetch.getAdvertisedRefs();
            for (Ref ref : refs) {
                if (!ref.getName().startsWith("refs/heads")) continue;
                results.add(ref);
            }
        }
        catch (InvalidRemoteException e) {
            e.printStackTrace();
        }
        return results;
    }

    public static List<Ref> getLocalBranches(Git repo) throws GitAPIException {
        return repo.branchList().call();
    }

    public static String getCurrentBranchName(Git repo) throws IOException {
        return repo.getRepository().getBranch();
    }

    public static Ref switchBranch(Git repo, String branchName) {
        Ref switchedBranch = null;
        try {
            switchedBranch = repo.checkout().setName(branchName).call();
            if (switchedBranch == null) {
                throw new RuntimeException("Couldn't switch to branch " + branchName);
            }
        }
        catch (GitAPIException e) {
            e.printStackTrace();
        }
        return switchedBranch;
    }

    public static List<String> getLogForCurrentBranch(Git repo) throws GitAPIException {
        ArrayList<String> results = new ArrayList<String>();
        Iterable commits = repo.log().call();
        for (RevCommit commit : commits) {
            results.add(commit.getFullMessage());
        }
        return results;
    }

    public static Iterable<RevCommit> getLogForBranch(Git repo, String branchName) throws GitAPIException, IOException {
        String oldBranch = repo.getRepository().getBranch();
        repo.checkout().setName(branchName).call();
        Iterable commits = repo.log().call();
        repo.checkout().setName(oldBranch).call();
        return commits;
    }

    public static void add(Git repo, String filepattern) throws GitAPIException {
        repo.add().addFilepattern(filepattern).call();
    }

    public static void addAll(Git repo) throws GitAPIException {
        repo.add().addFilepattern(".").call();
    }

    public static void commit(Git repo, String message) throws GitAPIException {
        repo.commit().setMessage(message).call();
    }

    public static void commitAll(Git repo, String message) throws GitAPIException {
        repo.commit().setMessage(message).setAll(true).call();
    }

    public static void stashCreate(Git repo) throws GitAPIException {
        repo.stashCreate().call();
    }

    public static void stashApply(Git repo, String ... stashRef) throws GitAPIException {
        if (stashRef.length >= 1 && !Strings.isNullOrEmpty((String)stashRef[0])) {
            repo.stashApply().setStashRef(stashRef[0]).call();
        } else {
            repo.stashApply().call();
        }
    }

    public static void stashDrop(Git repo) throws GitAPIException {
        repo.stashDrop().call();
    }

    public static void cherryPick(Git repo, Ref commit) throws GitAPIException {
        repo.cherryPick().include(commit).call();
    }

    public static CherryPickResult cherryPickNoMerge(Git git, Ref src) throws GitAPIException, CantMergeCommitWithZeroParentsException {
        LinkedList<Ref> cherryPickedRefs;
        RevCommit newHead;
        block12: {
            Repository repo = git.getRepository();
            newHead = null;
            cherryPickedRefs = new LinkedList<Ref>();
            RevWalk revWalk = new RevWalk(repo);
            try {
                RevCommit srcCommit;
                RevCommit headCommit;
                Ref headRef = repo.getRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = headCommit = revWalk.parseCommit((AnyObjectId)headRef.getObjectId());
                ObjectId srcObjectId = src.getPeeledObjectId();
                if (srcObjectId == null) {
                    srcObjectId = src.getObjectId();
                }
                if ((srcCommit = revWalk.parseCommit((AnyObjectId)srcObjectId)).getParentCount() == 0) {
                    throw new CantMergeCommitWithZeroParentsException("Commit with zero parents cannot be merged");
                }
                if (srcCommit.getParentCount() > 1) {
                    throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyCherryPickCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
                }
                RevCommit srcParent = srcCommit.getParent(0);
                revWalk.parseHeaders((RevObject)srcParent);
                ResolveMerger merger = (ResolveMerger)MergeStrategy.RESOLVE.newMerger(repo);
                merger.setWorkingTreeIterator((WorkingTreeIterator)new FileTreeIterator(repo));
                merger.setBase((AnyObjectId)srcParent.getTree());
                if (merger.merge(new AnyObjectId[]{headCommit, srcCommit})) {
                    DirCacheCheckout dco = new DirCacheCheckout(repo, (ObjectId)headCommit.getTree(), repo.lockDirCache(), merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.checkout();
                    cherryPickedRefs.add(src);
                    break block12;
                }
                if (merger.failed()) {
                    CherryPickResult dco = new CherryPickResult(merger.getFailingPaths());
                    return dco;
                }
                String message = new MergeMessageFormatter().formatWithConflicts(srcCommit.getFullMessage(), merger.getUnmergedPaths());
                repo.writeCherryPickHead(srcCommit.getId());
                repo.writeMergeCommitMsg(message);
                CherryPickResult cherryPickResult = CherryPickResult.CONFLICT;
                return cherryPickResult;
            }
            catch (IOException e) {
                throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfCherryPickCommand, e), (Throwable)e);
            }
            finally {
                revWalk.release();
            }
        }
        return new CherryPickResult(newHead, cherryPickedRefs);
    }

    public static void resetHard(Git repo, String newBase) throws GitAPIException {
        repo.reset().setMode(ResetCommand.ResetType.HARD).setRef(newBase).call();
    }

    public static Ref createBranch(Git git, String branchName) throws RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, GitAPIException {
        Ref newBranch = git.branchCreate().setName(branchName).call();
        if (newBranch == null) {
            throw new RuntimeException("Couldn't create new branch " + branchName);
        }
        return newBranch;
    }

    public static void close(Git repo) {
        if (repo != null) {
            repo.getRepository().close();
        }
    }
}

