/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git.gitignore;

import java.io.File;
import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.env.ConfigurationScope;

public class GitIgnoreConfig {
    private static final String CLONE_LOCATION_KEY = "gitignore.plugin.clone";
    private static final String REPOSITORY_KEY = "gitignore.plugin.repo";
    private static final String REPOSITORY = "https://github.com/github/gitignore.git";
    @Inject
    private Configuration config;

    public String defaultRemoteRepository() {
        return REPOSITORY;
    }

    public String remoteRepository() {
        Configuration user = this.userConfig();
        if (user.containsKey(REPOSITORY_KEY)) {
            return user.getString(REPOSITORY_KEY);
        }
        return this.defaultRemoteRepository();
    }

    public void setRemoteRepository(String repoUrl) {
        this.userConfig().setProperty(REPOSITORY_KEY, (Object)repoUrl);
    }

    public File defaultLocalRepository() {
        return new File(System.getProperty("user.home") + File.separator + ".gitignore_boilerplate");
    }

    public File localRepository() {
        Configuration user = this.userConfig();
        if (user.containsKey(CLONE_LOCATION_KEY)) {
            return new File(user.getString(CLONE_LOCATION_KEY));
        }
        return this.defaultLocalRepository();
    }

    public void setLocalRepository(String location) {
        this.userConfig().setProperty(CLONE_LOCATION_KEY, (Object)location);
    }

    private Configuration userConfig() {
        return this.config.getScopedConfiguration(ConfigurationScope.USER);
    }
}

