/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git.gitignore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.jboss.forge.git.GitFacet;
import org.jboss.forge.git.GitUtils;
import org.jboss.forge.git.gitignore.GitIgnoreConfig;
import org.jboss.forge.git.gitignore.GitIgnoreTemplateGroup;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.util.Streams;

@Alias(value="forge.vcs.git.ignore")
@RequiresFacet(value={GitFacet.class})
public class GitIgnoreFacet
extends BaseFacet {
    public static final String GITIGNORE = ".gitignore";
    private static final String GLOBAL_TEMPLATES = "Global";
    @Inject
    private GitIgnoreConfig config;
    @Inject
    private ResourceFactory factory;
    @Inject
    private Shell shell;

    public boolean install() {
        try {
            DirectoryResource cloneDir = this.cloneDir();
            String repo = this.config.remoteRepository();
            ShellMessages.info((ShellPrintWriter)this.shell, (String)("Cloning " + repo + " into " + cloneDir.getFullyQualifiedName()));
            Git git = GitUtils.clone(cloneDir, repo);
            GitUtils.close(git);
            return true;
        }
        catch (Exception e) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Failed to checkout gitignore: " + e));
            return false;
        }
    }

    public boolean isInstalled() {
        File clone = this.config.localRepository();
        Resource cloneDir = this.factory.getResourceFrom(clone);
        return cloneDir.exists() && cloneDir.getChild(".git").exists();
    }

    public List<GitIgnoreTemplateGroup> list() {
        ArrayList<GitIgnoreTemplateGroup> result = new ArrayList<GitIgnoreTemplateGroup>(2);
        DirectoryResource languages = this.cloneDir();
        result.add(new GitIgnoreTemplateGroup("Languages", this.listGitignores(languages)));
        result.add(new GitIgnoreTemplateGroup("Globals", this.listGitignores(languages.getChildDirectory(GLOBAL_TEMPLATES))));
        return result;
    }

    public String contentOf(String template) {
        DirectoryResource[] candidates;
        for (DirectoryResource dir : candidates = new DirectoryResource[]{this.cloneDir(), this.cloneDir().getChildDirectory(GLOBAL_TEMPLATES)}) {
            if (!this.listGitignores(dir).contains(template)) continue;
            FileResource file = (FileResource)dir.getChildOfType(FileResource.class, template + GITIGNORE);
            return Streams.toString((InputStream)file.getResourceInputStream());
        }
        return "";
    }

    public void update() throws IOException, GitAPIException {
        Git git = GitUtils.git(this.cloneDir());
        GitUtils.pull(git, 10000);
        GitUtils.close(git);
    }

    private List<String> listGitignores(DirectoryResource dir) {
        LinkedList<String> result = new LinkedList<String>();
        ResourceFilter filter = new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource.getName().endsWith(GitIgnoreFacet.GITIGNORE);
            }
        };
        for (Resource resource : dir.listResources(filter)) {
            String name = resource.getName();
            String cut = name.substring(0, name.indexOf(GITIGNORE));
            result.add(cut);
        }
        return result;
    }

    private DirectoryResource cloneDir() {
        return new DirectoryResource(this.factory, this.config.localRepository());
    }
}

