/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.cdi;

import java.io.FileNotFoundException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaAnnotation;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.SyntaxError;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.events.PickupResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.spec.javaee.CDIFacet;
import org.jboss.forge.spec.javaee.cdi.BeanScope;

@Alias(value="beans")
@RequiresFacet(value={CDIFacet.class})
public class BeansPlugin
implements Plugin {
    private static final Set<ElementType> STEREOTYPE_TARGETS;
    @Inject
    private Event<InstallFacets> install;
    @Inject
    private Event<PickupResource> pickup;
    @Inject
    private Project project;
    @Inject
    private ShellPrompt prompt;
    @Inject
    Shell shell;
    @Inject
    @Current
    private JavaResource resource;

    @SetupCommand
    public void setup(PipeOut out) {
        if (!this.project.hasFacet(CDIFacet.class)) {
            this.install.fire((Object)new InstallFacets(CDIFacet.class));
        }
        if (this.project.hasFacet(CDIFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Beans (CDI) is installed.");
        }
    }

    @Command(value="list-interceptors")
    public void listInterceptors(PipeOut out) {
        CDIFacet cdi = (CDIFacet)this.project.getFacet(CDIFacet.class);
        List interceptors = cdi.getConfig().getInterceptors();
        for (String i : interceptors) {
            out.println(i);
        }
    }

    @Command(value="list-decorators")
    public void listDecorators(PipeOut out) {
        CDIFacet cdi = (CDIFacet)this.project.getFacet(CDIFacet.class);
        List decorators = cdi.getConfig().getDecorators();
        for (String d : decorators) {
            out.println(d);
        }
    }

    @Command(value="list-alternatives")
    public void listAlternatives(PipeOut out) {
        CDIFacet cdi = (CDIFacet)this.project.getFacet(CDIFacet.class);
        List classes = cdi.getConfig().getAlternativeClasses();
        List stereotypes = cdi.getConfig().getAlternativeStereotypes();
        if (!out.isPiped()) {
            out.println(ShellColor.BOLD, "Stereotypes:");
        }
        for (String s : stereotypes) {
            out.println(s);
        }
        if (!out.isPiped()) {
            out.println(ShellColor.BOLD, "Classes:");
        }
        for (String c : classes) {
            out.println(c);
        }
    }

    @Command(value="new-conversation")
    @RequiresResource(value={JavaResource.class})
    public void newConversation(@Option(name="timeout") Long timeout, @Option(name="named", defaultValue="") String name, @Option(name="beginMethodName", defaultValue="beginConversation") String beginName, @Option(name="endMethodName", defaultValue="endConversation") String endName, @Option(name="conversationFieldName", defaultValue="conversation") String fieldName, @Option(name="overwrite") boolean overwrite, PipeOut out) throws FileNotFoundException {
        if (this.resource.exists()) {
            if (this.resource.getJavaSource().isClass()) {
                JavaClass javaClass = (JavaClass)this.resource.getJavaSource();
                if (javaClass.hasField(fieldName) && !javaClass.getField(fieldName).isType(Conversation.class)) {
                    if (overwrite) {
                        javaClass.removeField(javaClass.getField(fieldName));
                    } else {
                        throw new RuntimeException("Field [" + fieldName + "] exists. Re-run with '--overwrite' to continue.");
                    }
                }
                if (javaClass.hasMethodSignature(beginName) && javaClass.getMethod(beginName).getParameters().size() == 0) {
                    if (overwrite) {
                        javaClass.removeMethod(javaClass.getMethod(beginName));
                    } else {
                        throw new RuntimeException("Method [" + beginName + "] exists. Re-run with '--overwrite' to continue.");
                    }
                }
                if (javaClass.hasMethodSignature(endName) && javaClass.getMethod(endName).getParameters().size() == 0) {
                    if (overwrite) {
                        javaClass.removeMethod(javaClass.getMethod(endName));
                    } else {
                        throw new RuntimeException("Method [" + endName + "] exists. Re-run with '--overwrite' to continue.");
                    }
                }
                ((Field)javaClass.addField().setPrivate()).setName(fieldName).setType(Conversation.class).addAnnotation(Inject.class);
                Method beginMethod = ((Method)javaClass.addMethod().setName(beginName).setReturnTypeVoid().setPublic()).setBody(fieldName + ".begin(" + name + ");");
                if (timeout != null) {
                    beginMethod.setBody(beginMethod.getBody() + "\n" + fieldName + ".setTimeout(" + timeout + ");");
                }
                ((Method)javaClass.addMethod().setName(endName).setReturnTypeVoid().setPublic()).setBody(fieldName + ".end();");
                if (javaClass.hasSyntaxErrors()) {
                    ShellMessages.info((ShellPrintWriter)out, (String)"Modified Java class contains syntax errors:");
                    for (SyntaxError error : javaClass.getSyntaxErrors()) {
                        out.print(error.getDescription());
                    }
                }
                this.resource.setContents((JavaSource)javaClass);
            } else {
                ShellMessages.error((ShellPrintWriter)out, (String)("Must operate on a Java Class file, not an [" + this.resource.getJavaSource().getSourceType() + "]"));
            }
        }
    }

    @Command(value="new-bean")
    public void newBean(@Option(required=true, name="type") JavaResource resource, @Option(required=true, name="scoped") BeanScope scope, @Option(required=false, name="overwrite") boolean overwrite) throws FileNotFoundException {
        if (resource.exists() && !overwrite) {
            throw new RuntimeException("Type already exists [" + resource.getFullyQualifiedName() + "] Re-run with '--overwrite' to continue.");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaClass javaClass = (JavaClass)JavaParser.create(JavaClass.class);
        javaClass.setName(java.calculateName(resource));
        javaClass.setPackage(java.calculatePackage(resource));
        if (BeanScope.CUSTOM == scope) {
            String annoType = this.prompt.promptCommon("Enter the qualified custom scope type:", PromptType.JAVA_CLASS);
            javaClass.addAnnotation(annoType);
        } else if (BeanScope.DEPENDENT != scope) {
            javaClass.addAnnotation(scope.getAnnotation());
        }
        java.saveJavaSource((JavaSource)javaClass);
        this.pickup.fire((Object)new PickupResource((Resource)java.getJavaResource((JavaSource)javaClass)));
    }

    @Command(value="new-qualifier")
    public void newQualifier(@Option(required=true, name="type") JavaResource resource, @Option(required=false, name="overwrite") boolean overwrite, @Option(required=false, name="inherited") boolean inherited) throws FileNotFoundException {
        if (resource.exists() && !overwrite) {
            throw new RuntimeException("Type already exists [" + resource.getFullyQualifiedName() + "] Re-run with '--overwrite' to continue.");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaAnnotation qualifier = (JavaAnnotation)JavaParser.create(JavaAnnotation.class);
        qualifier.setName(java.calculateName(resource));
        qualifier.setPackage(java.calculatePackage(resource));
        qualifier.addAnnotation(Qualifier.class);
        if (inherited) {
            qualifier.addAnnotation(Inherited.class);
        }
        qualifier.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        qualifier.addAnnotation(Target.class).setEnumValue(new Enum[]{ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE});
        qualifier.addAnnotation(Documented.class);
        java.saveJavaSource((JavaSource)qualifier);
        this.pickup.fire((Object)new PickupResource((Resource)java.getJavaResource((JavaSource)qualifier)));
    }

    @Command(value="new-stereotype")
    public void newStereotype(@Option(required=true, name="type") JavaResource resource, @Option(required=false, name="overwrite") boolean overwrite, @Option(required=false, name="inherited") boolean inherited, @Option(required=false, name="named") boolean named, @Option(required=false, name="alternative") boolean alternative, @Option(required=false, help="allow this stereotype to be used on any valid @Target element type (TYPE, METHOD, FIELD)", description="all @Target element types", name="all-targets") boolean allTargets) throws FileNotFoundException {
        Set targetTypes;
        if (resource.exists() && !overwrite) {
            throw new RuntimeException("Type already exists [" + resource.getFullyQualifiedName() + "] Re-run with '--overwrite' to continue.");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaAnnotation stereotype = (JavaAnnotation)JavaParser.create(JavaAnnotation.class);
        stereotype.setName(java.calculateName(resource));
        stereotype.setPackage(java.calculatePackage(resource));
        stereotype.addAnnotation(Stereotype.class);
        if (inherited) {
            stereotype.addAnnotation(Inherited.class);
        }
        if (named) {
            stereotype.addAnnotation(Named.class);
        }
        if (alternative) {
            stereotype.addAnnotation(Alternative.class);
        }
        stereotype.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        if (allTargets) {
            targetTypes = STEREOTYPE_TARGETS;
        } else {
            Set input;
            while (true) {
                if ((input = this.shell.promptMultiSelect("Select target element types", STEREOTYPE_TARGETS)).isEmpty()) {
                    ShellMessages.error((ShellPrintWriter)this.shell, (String)"No target element types selected");
                    continue;
                }
                if (!input.contains((Object)ElementType.TYPE) || input.size() != 2) break;
                ShellMessages.error((ShellPrintWriter)this.shell, (String)("Invalid combination of target element types: " + input));
            }
            targetTypes = input;
        }
        stereotype.addAnnotation(Target.class).setEnumValue((Enum[])targetTypes.toArray(new ElementType[targetTypes.size()]));
        stereotype.addAnnotation(Documented.class);
        java.saveJavaSource((JavaSource)stereotype);
        this.pickup.fire((Object)new PickupResource((Resource)java.getJavaResource((JavaSource)stereotype)));
    }

    @Command(value="new-scope")
    public void newScope(@Option(required=true, name="type") JavaResource resource, @Option(required=false, name="overwrite") boolean overwrite, @Option(required=false, name="pseudo", help="mutually exclusive with 'passivating'") boolean pseudo, @Option(required=false, name="passivating", help="mutually exclusive with 'pseudo'") boolean passivating) throws FileNotFoundException {
        if (pseudo && passivating) {
            throw new RuntimeException("Cannot create a passivating pseudo-scope!");
        }
        if (resource.exists() && !overwrite) {
            throw new RuntimeException("Type already exists [" + resource.getFullyQualifiedName() + "] Re-run with '--overwrite' to continue.");
        }
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        JavaAnnotation scope = (JavaAnnotation)JavaParser.create(JavaAnnotation.class);
        scope.setName(java.calculateName(resource));
        scope.setPackage(java.calculatePackage(resource));
        if (pseudo) {
            scope.addAnnotation(Scope.class);
        } else {
            Annotation normalScope = scope.addAnnotation(NormalScope.class);
            if (passivating) {
                normalScope.setLiteralValue("passivating", Boolean.toString(true));
            }
        }
        scope.addAnnotation(Retention.class).setEnumValue(new Enum[]{RetentionPolicy.RUNTIME});
        scope.addAnnotation(Target.class).setEnumValue(new Enum[]{ElementType.TYPE, ElementType.METHOD, ElementType.FIELD});
        scope.addAnnotation(Documented.class);
        java.saveJavaSource((JavaSource)scope);
        this.pickup.fire((Object)new PickupResource((Resource)java.getJavaResource((JavaSource)scope)));
    }

    static {
        LinkedHashSet stereotypeTargets = new LinkedHashSet();
        Collections.addAll(stereotypeTargets, ElementType.TYPE, ElementType.METHOD, ElementType.FIELD);
        STEREOTYPE_TARGETS = Collections.unmodifiableSet(stereotypeTargets);
    }
}

