/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.validation;

import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.spec.javaee.ValidationFacet;
import org.jboss.forge.spec.javaee.descriptor.ValidationDescriptor;
import org.jboss.forge.spec.javaee.validation.provider.BVProvider;
import org.jboss.forge.spec.javaee.validation.provider.ValidationProvider;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

@Alias(value="validation")
@RequiresProject
@RequiresFacet(value={DependencyFacet.class})
public class ValidationPlugin
implements Plugin {
    private final Project project;
    private final BeanManager beanManager;
    private final Event<InstallFacets> request;
    private final ShellPrompt prompt;
    private final DependencyInstaller installer;

    @Inject
    public ValidationPlugin(Project project, Event<InstallFacets> request, BeanManager beanManager, ShellPrompt prompt, DependencyInstaller installer) {
        this.project = project;
        this.beanManager = beanManager;
        this.request = request;
        this.prompt = prompt;
        this.installer = installer;
    }

    @Command(value="setup", help="Setup validation for this project")
    public void setup(@Option(name="provider", defaultValue="HIBERNATE_VALIDATOR", required=true) BVProvider providerType, @Option(name="messageInterpolator", type=PromptType.JAVA_CLASS) String messageInterpolator, @Option(name="traversableResolver", type=PromptType.JAVA_CLASS) String traversableResolver, @Option(name="constraintValidatorFactory", type=PromptType.JAVA_CLASS) String constraintValidatorFactory) {
        ValidationProvider provider = providerType.getValidationProvider(this.beanManager);
        if (!this.project.hasFacet(ValidationFacet.class)) {
            this.request.fire((Object)new InstallFacets(ValidationFacet.class));
        }
        this.installDependencies(provider.getDependencies());
        if (!provider.getAdditionalDependencies().isEmpty() && this.prompt.promptBoolean("Would you install " + providerType.getName() + " additional dependencies?", false)) {
            this.installDependencies(provider.getAdditionalDependencies());
        }
        if (provider.getDefaultDescriptor() != null) {
            ValidationDescriptor providerDescriptor = provider.getDefaultDescriptor();
            ValidationDescriptor descriptor = ((ValidationDescriptor)Descriptors.create(ValidationDescriptor.class)).setDefaultProvider(providerDescriptor.getDefaultProvider()).setMessageInterpolator(messageInterpolator == null ? providerDescriptor.getMessageInterpolator() : messageInterpolator).setTraversableResolver(traversableResolver == null ? providerDescriptor.getTraversableResolver() : traversableResolver).setConstraintValidatorFactory(constraintValidatorFactory == null ? providerDescriptor.getConstraintValidatorFactory() : constraintValidatorFactory);
            ((ValidationFacet)this.project.getFacet(ValidationFacet.class)).saveConfig(descriptor);
        }
    }

    private void installDependencies(Set<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            if (this.installer.isInstalled(this.project, dep)) continue;
            dep = DependencyBuilder.create((Dependency)dep).setScopeType(this.promptForScope(dep));
            this.installer.install(this.project, dep);
        }
    }

    private ScopeType promptForScope(Dependency dep) {
        boolean answer = this.prompt.promptBoolean("Should the dependency be packaged with your application (not provided by the server)?", false);
        return answer ? ScopeType.COMPILE : ScopeType.PROVIDED;
    }
}

