/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.validation.provider;

import javax.enterprise.inject.spi.BeanManager;
import org.jboss.forge.shell.util.BeanManagerUtils;
import org.jboss.forge.spec.javaee.validation.provider.ApacheBeanValidationProvider;
import org.jboss.forge.spec.javaee.validation.provider.HibernateValidatorProvider;
import org.jboss.forge.spec.javaee.validation.provider.JavaEEValidatorProvider;
import org.jboss.forge.spec.javaee.validation.provider.ValidationProvider;

public enum BVProvider {
    JAVA_EE("Generic Java EE", JavaEEValidatorProvider.class),
    HIBERNATE_VALIDATOR("Hibernate Validator", HibernateValidatorProvider.class),
    APACHE_BEAN_VALIDATION("Apache Bean Validation", ApacheBeanValidationProvider.class);

    private final String name;
    private final Class<? extends ValidationProvider> validationProviderClass;

    private BVProvider(String name, Class<? extends ValidationProvider> validationProviderClass) {
        this.name = name;
        this.validationProviderClass = validationProviderClass;
    }

    public String getName() {
        return this.name;
    }

    public ValidationProvider getValidationProvider(BeanManager manager) {
        return (ValidationProvider)BeanManagerUtils.getContextualInstance((BeanManager)manager, this.validationProviderClass);
    }

    public Class<? extends ValidationProvider> getValidationProviderClass() {
        return this.validationProviderClass;
    }
}

