/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.validation;

import java.io.FileNotFoundException;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.completer.PropertyCompleter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.util.ResourceUtil;
import org.jboss.forge.spec.javaee.ValidationFacet;
import org.jboss.forge.spec.javaee.validation.util.JavaHelper;

@Alias(value="remove-constraint")
@RequiresResource(value={JavaResource.class})
@RequiresFacet(value={ValidationFacet.class, JavaSourceFacet.class})
public class RemovePropertyConstraintPlugin
implements Plugin {
    private final Shell shell;
    private final Project project;

    @Inject
    public RemovePropertyConstraintPlugin(Shell shell, Project project) {
        this.shell = shell;
        this.project = project;
    }

    @DefaultCommand(help="Removes the given constraint on the given property/property accessor")
    public void removePropertyConstraint(@Option(name="property", completer=PropertyCompleter.class, required=true) String property, @Option(name="named", required=true) String constraint, @Option(name="onAccessor", flagOnly=true) boolean onAccessor) throws FileNotFoundException {
        JavaClass clazz = ResourceUtil.getJavaClassFromResource((Resource)this.shell.getCurrentResource());
        Member<JavaClass, ?> member = this.getMember(clazz, property, onAccessor);
        if (member == null) {
            throw new IllegalStateException("There is no property named '" + property + "' or accessor for this property");
        }
        if (!this.removeConstraint(member, constraint)) {
            throw new IllegalStateException("There is no constraint named '" + constraint + "' on " + member.getName());
        }
        ((JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)clazz);
        this.shell.println("Constraint named '" + constraint + "' has been successfully removed.\n");
    }

    private Member<JavaClass, ?> getMember(JavaClass clazz, String property, boolean onAccessor) {
        Field field = clazz.getField(property);
        if (field != null && onAccessor) {
            return JavaHelper.getFieldAccessor((Field<JavaClass>)field);
        }
        return field;
    }

    private boolean removeConstraint(Member<JavaClass, ?> member, String constraint) {
        List annotations = member.getAnnotations();
        for (Annotation oneAnnotation : annotations) {
            if (!oneAnnotation.getName().equals(constraint)) continue;
            member.removeAnnotation(oneAnnotation);
            return true;
        }
        return false;
    }
}

