/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.project.ProjectScoped;

public class DTOCollection {
    private Map<JavaClass, DTOPair> dtos = new HashMap<JavaClass, DTOPair>();
    @Inject
    @ProjectScoped
    private Project project;
    @Inject
    private ShellPrompt prompt;

    public Collection<JavaResource> allResources() {
        ArrayList<JavaResource> result = new ArrayList<JavaResource>();
        for (DTOPair pair : this.dtos.values()) {
            if (pair.rootDTO != null) {
                result.add(pair.rootDTO);
            }
            if (pair.nestedDTO == null) continue;
            result.add(pair.nestedDTO);
        }
        return result;
    }

    public void addRootDTO(JavaClass entity, JavaClass rootDTO) {
        DTOPair dtoPair;
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        DTOPair dTOPair = dtoPair = this.dtos.containsKey(entity) ? this.dtos.get(entity) : new DTOPair();
        if (rootDTO != null) {
            try {
                if (!java.getJavaResource((JavaSource)rootDTO).exists() || this.prompt.promptBoolean("DTO [" + rootDTO.getQualifiedName() + "] already, exists. Overwrite?")) {
                    dtoPair.rootDTO = java.saveJavaSource((JavaSource)rootDTO);
                }
            }
            catch (FileNotFoundException fileEx) {
                throw new RuntimeException(fileEx);
            }
        }
        this.dtos.put(entity, dtoPair);
    }

    public void addNestedDTO(JavaClass entity, JavaClass nestedDTO) {
        DTOPair dtoPair;
        JavaSourceFacet java = (JavaSourceFacet)this.project.getFacet(JavaSourceFacet.class);
        DTOPair dTOPair = dtoPair = this.dtos.containsKey(entity) ? this.dtos.get(entity) : new DTOPair();
        if (nestedDTO != null) {
            try {
                if (!java.getJavaResource((JavaSource)nestedDTO).exists() || this.prompt.promptBoolean("DTO [" + nestedDTO.getQualifiedName() + "] already, exists. Overwrite?")) {
                    dtoPair.nestedDTO = java.saveJavaSource((JavaSource)nestedDTO);
                }
            }
            catch (FileNotFoundException fileEx) {
                throw new RuntimeException(fileEx);
            }
        }
        this.dtos.put(entity, dtoPair);
    }

    public boolean containsDTOFor(JavaClass entity, boolean root) {
        if (this.dtos.get(entity) == null) {
            return false;
        }
        return root ? this.dtos.get(entity).rootDTO != null : this.dtos.get(entity).nestedDTO != null;
    }

    public JavaClass getDTOFor(JavaClass entity, boolean root) {
        JavaClass javaClass;
        if (this.dtos.get(entity) == null) {
            return null;
        }
        JavaResource javaResource = root ? this.dtos.get(entity).rootDTO : this.dtos.get(entity).nestedDTO;
        try {
            javaClass = (JavaClass)javaResource.getJavaSource();
        }
        catch (FileNotFoundException fileEx) {
            return null;
        }
        return javaClass;
    }

    public class DTOPair {
        private JavaResource rootDTO;
        private JavaResource nestedDTO;

        public JavaResource getRootDTO() {
            return this.rootDTO;
        }

        public JavaResource getNestedDTO() {
            return this.nestedDTO;
        }
    }
}

