/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.rest;

import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.env.ConfigurationFactory;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.spec.javaee.RestWebXmlFacet;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.impl.spec.servlet.web.WebAppDescriptorImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

@Alias(value="forge.spec.jaxrs.webxml")
public class RestWebXmlFacetImpl
extends BaseFacet
implements RestWebXmlFacet {
    public static final String JAXRS_SERVLET = "javax.ws.rs.core.Application";
    @Inject
    private ConfigurationFactory configurationFactory;
    private Configuration configuration;

    public boolean install() {
        if (!this.installedInWebXML()) {
            Node mapping;
            ServletFacet servlet = (ServletFacet)this.project.getFacet(ServletFacet.class);
            WebAppDescriptorImpl web = (WebAppDescriptorImpl)servlet.getConfig();
            Node node = web.getRootNode();
            Node servletClass = node.getSingle("servlet/servlet-name=javax.ws.rs.core.Application");
            Node servletMapping = node.getSingle("servlet-mapping/servlet-name=javax.ws.rs.core.Application");
            if (servletClass == null) {
                mapping = node.createChild("servlet");
                mapping.createChild("servlet-name").text(JAXRS_SERVLET);
                mapping.createChild("load-on-startup").text("1");
            }
            if (servletMapping == null) {
                mapping = node.createChild("servlet-mapping");
                mapping.createChild("servlet-name").text(JAXRS_SERVLET);
                String urlPattern = this.getProjectConfiguration().getString("rootpath");
                if (urlPattern.endsWith("/")) {
                    urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
                }
                mapping.createChild("url-pattern").text(urlPattern + "/*");
            }
            servlet.saveConfig((WebAppDescriptor)web);
        }
        return true;
    }

    public boolean isInstalled() {
        return this.installedInWebXML();
    }

    private boolean installedInWebXML() {
        return this.getServletPath() != null;
    }

    public String getServletPath() {
        Node url;
        ServletFacet servlet;
        WebAppDescriptorImpl web;
        Node node;
        Node servletClass;
        if (this.project.hasFacet(ServletFacet.class) && (servletClass = (node = (web = (WebAppDescriptorImpl)(servlet = (ServletFacet)this.project.getFacet(ServletFacet.class)).getConfig()).getRootNode()).getSingle("servlet-mapping/servlet-name=javax.ws.rs.core.Application")) != null && (url = servletClass.getParent().getSingle("url-pattern")) != null) {
            return url.getText();
        }
        return null;
    }

    public void setApplicationPath(String path) {
        this.getProjectConfiguration().setProperty("rootpath", (Object)path);
        ServletFacet servlet = (ServletFacet)this.project.getFacet(ServletFacet.class);
        WebAppDescriptorImpl web = (WebAppDescriptorImpl)servlet.getConfig();
        Node node = web.getRootNode();
        Node servletClass = node.getSingle("servlet-mapping/servlet-name=javax.ws.rs.core.Application");
        if (servletClass != null) {
            servletClass.getParent().getOrCreate("url-pattern").text(path);
        }
        servlet.saveConfig((WebAppDescriptor)web);
    }

    private Configuration getProjectConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.configurationFactory.getProjectConfig(this.project);
        }
        return this.configuration;
    }
}

