/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.xml.query;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.query.CreateQuery;
import org.jboss.forge.parser.xml.query.GetSingleQuery;
import org.jboss.forge.parser.xml.query.Pattern;
import org.jboss.forge.parser.xml.query.Query;
import org.jboss.forge.parser.xml.util.QueryUtil;

public enum GetOrCreateQuery implements Query<Node>
{
    INSTANCE;

    private static final Logger log;
    private static final Pattern[] PATTERN_CAST;

    @Override
    public Node execute(Node node, Pattern ... patterns) {
        QueryUtil.validateNodeAndPatterns(node, patterns);
        List<Pattern> patternList = Arrays.asList(patterns);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Looking to create: " + patternList + " on " + node.toString(true));
        }
        Node found = this.findOrCreate(node, patternList, patterns);
        return found;
    }

    private Node findOrCreate(Node root, List<Pattern> patternsToSearch, Pattern ... allPatterns) {
        int offset;
        int numPatternsToCreate;
        Pattern[] patternsToCreate;
        Node found = GetSingleQuery.INSTANCE.execute(root, patternsToSearch.toArray(PATTERN_CAST));
        if (found == null && patternsToSearch.size() > 1) {
            return this.findOrCreate(root, patternsToSearch.subList(0, patternsToSearch.size() - 1), allPatterns);
        }
        if (found == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Still not found, root: " + root);
            }
            return CreateQuery.INSTANCE.execute(root, allPatterns);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Found " + found + " matching " + patternsToSearch);
        }
        if ((patternsToCreate = new Pattern[numPatternsToCreate = allPatterns.length - (offset = patternsToSearch.size())]).length > 0) {
            for (int i = 0; i < numPatternsToCreate; ++i) {
                patternsToCreate[i] = allPatterns[offset + i];
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Attempting to create " + Arrays.asList(patternsToCreate) + " on " + found);
            }
            Node newNode = CreateQuery.INSTANCE.execute(found, patternsToCreate);
            return newNode;
        }
        return found;
    }

    static {
        log = Logger.getLogger(GetOrCreateQuery.class.getName());
        PATTERN_CAST = new Pattern[0];
    }
}

