/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.JavaExecutionFacet;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.util.OSUtils;

@Dependent
@Alias(value="forge.maven.JavaExecutionFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class JavaExecutionFacetImpl
extends BaseFacet
implements JavaExecutionFacet {
    @Inject
    ShellPrintWriter out;
    @Inject
    Shell shell;

    public void executeProjectClass(String fullyQualifiedClassName, String ... arguments) {
        this.compileProjectClasses();
        CommandBuilder commandBuilder = CommandBuilder.getBuilder().mainClass(fullyQualifiedClassName).withArguments(arguments);
        if (this.shell.isVerbose()) {
            commandBuilder.setVerbose();
        }
        this.executeClass(commandBuilder.build());
    }

    private void executeClass(String[] mvnArguments) {
        ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).executeMaven(this.out, mvnArguments);
    }

    private void compileProjectClasses() {
        String[] compileArgs = new String[]{"test-compile"};
        ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).executeMaven(this.out, compileArgs);
    }

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return true;
    }

    private static class CommandBuilder {
        private final List<String> commands = new ArrayList<String>();

        private CommandBuilder() {
        }

        public static CommandBuilder getBuilder() {
            CommandBuilder builder = new CommandBuilder();
            builder.commands.add("exec:java");
            builder.commands.add("-Dexec.classpathScope=test");
            return builder;
        }

        public CommandBuilder mainClass(String mainClass) {
            this.commands.add("-Dexec.mainClass=" + mainClass);
            return this;
        }

        public CommandBuilder withArguments(String[] arguments) {
            if (arguments.length > 0) {
                String quotes = OSUtils.isWindows() ? "\\\"" : "\"";
                StringBuilder argBuilder = new StringBuilder("-Dexec.args=").append(quotes);
                boolean first = true;
                for (String argument : arguments) {
                    if (!first) {
                        argBuilder.append(" ");
                    }
                    argBuilder.append(argument);
                    first = false;
                }
                argBuilder.append(quotes).append(" ");
                this.commands.add(argBuilder.toString());
            }
            return this;
        }

        public void setVerbose() {
            this.commands.add("-X");
        }

        public String[] build() {
            String[] args = new String[this.commands.size()];
            return this.commands.toArray(args);
        }
    }
}

