/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.io.File;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.facets.MavenProjectBuilder;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.build.ProjectBuilder;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.project.packaging.events.PackagingChanged;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;

@Dependent
@Alias(value="forge.maven.PackagingFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenPackagingFacet
extends BaseFacet
implements PackagingFacet,
Facet {
    @Inject
    private Event<PackagingChanged> event;
    @Inject
    private ResourceFactory factory;
    @Inject
    private Shell shell;
    @Inject
    private ForgeEnvironment environment;

    public void setPackagingType(PackagingType type) {
        PackagingType oldType = this.getPackagingType();
        if (!oldType.equals((Object)type)) {
            MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = mavenFacet.getPOM();
            pom.setPackaging(type.getType());
            mavenFacet.setPOM(pom);
            this.event.fire((Object)new PackagingChanged(this.project, oldType, type));
        }
    }

    public PackagingType getPackagingType() {
        MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mavenFacet.getPOM();
        return PackagingType.from((String)pom.getPackaging());
    }

    public boolean isInstalled() {
        try {
            this.project.getFacet(MavenCoreFacet.class);
            return true;
        }
        catch (FacetNotFoundException e) {
            return false;
        }
    }

    public boolean install() {
        if (PackagingType.NONE.equals((Object)this.getPackagingType())) {
            this.setPackagingType(PackagingType.BASIC);
        }
        return true;
    }

    public Resource<?> getFinalArtifact() {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        String directory = mvn.getPartialProjectBuildingResult().getProject().getBuild().getDirectory();
        String finalName = mvn.getPartialProjectBuildingResult().getProject().getBuild().getFinalName();
        if (Strings.isNullOrEmpty((String)directory)) {
            throw new IllegalStateException("Project build directory is not configured");
        }
        if (Strings.isNullOrEmpty((String)finalName)) {
            throw new IllegalStateException("Project final artifact name is not configured");
        }
        return this.factory.getResourceFrom(new File(directory.trim() + "/" + finalName + "." + this.getPackagingType().getType().toLowerCase()));
    }

    public Resource<?> executeBuild(String ... args) {
        return this.createBuilder().addArguments(args).build();
    }

    public ProjectBuilder createBuilder() {
        return new MavenProjectBuilder(this.environment, this.project);
    }

    public String getFinalName() {
        MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mavenFacet.getPOM();
        Build build = pom.getBuild();
        return build != null ? build.getFinalName() : this.getDefaultFinalName();
    }

    private String getDefaultFinalName() {
        MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mavenFacet.getPOM();
        String version = pom.getVersion();
        if (version == null && pom.getParent() != null) {
            version = pom.getParent().getVersion();
        }
        return pom.getArtifactId() + "-" + version;
    }

    public void setFinalName(String finalName) {
        MavenCoreFacet mavenFacet = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mavenFacet.getPOM();
        Build build = pom.getBuild();
        if (build == null) {
            build = new Build();
            pom.setBuild(build);
        }
        pom.getBuild().setFinalName(finalName);
        mavenFacet.setPOM(pom);
    }
}

