/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.metawidget;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.project.Project;
import org.jboss.forge.scaffoldx.metawidget.inspector.ForgeInspector;
import org.jboss.forge.scaffoldx.metawidget.inspector.propertystyle.ForgePropertyStyle;
import org.jboss.forge.scaffoldx.metawidget.inspector.propertystyle.ForgePropertyStyleConfig;
import org.metawidget.inspector.beanvalidation.BeanValidationInspector;
import org.metawidget.inspector.composite.CompositeInspector;
import org.metawidget.inspector.composite.CompositeInspectorConfig;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.inspector.jpa.JpaInspector;
import org.metawidget.inspector.jpa.JpaInspectorConfig;
import org.metawidget.inspector.propertytype.PropertyTypeInspector;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetawidgetInspectorFacade {
    private Project project;
    private CompositeInspector compositeInspector;

    @Inject
    public MetawidgetInspectorFacade(Project project) {
        this.project = project;
    }

    public List<Map<String, String>> inspect(JavaClass klass) {
        this.setupCompositeInspector();
        Element inspectionResult = this.compositeInspector.inspectAsDom(null, klass.getQualifiedName(), (String[])null);
        Element inspectedEntity = XmlUtils.getFirstChildElement((Element)inspectionResult);
        Element inspectedProperty = XmlUtils.getFirstChildElement((Element)inspectedEntity);
        ArrayList<Map<String, String>> viewPropertyAttributes = new ArrayList<Map<String, String>>();
        while (inspectedProperty != null) {
            Map propertyAttributes = XmlUtils.getAttributesAsMap((Node)inspectedProperty);
            viewPropertyAttributes.add(propertyAttributes);
            inspectedProperty = XmlUtils.getNextSiblingElement((Element)inspectedProperty);
        }
        return viewPropertyAttributes;
    }

    private void setupCompositeInspector() {
        ForgePropertyStyleConfig forgePropertyStyleConfig = new ForgePropertyStyleConfig();
        forgePropertyStyleConfig.setProject(this.project);
        BaseObjectInspectorConfig baseObjectInspectorConfig = new BaseObjectInspectorConfig();
        baseObjectInspectorConfig.setPropertyStyle((PropertyStyle)new ForgePropertyStyle(forgePropertyStyleConfig));
        PropertyTypeInspector propertyTypeInspector = new PropertyTypeInspector(baseObjectInspectorConfig);
        ForgeInspector forgeInspector = new ForgeInspector(baseObjectInspectorConfig);
        JpaInspectorConfig jpaInspectorConfig = new JpaInspectorConfig();
        jpaInspectorConfig.setHideIds(true);
        jpaInspectorConfig.setHideVersions(true);
        jpaInspectorConfig.setHideTransients(true);
        jpaInspectorConfig.setPropertyStyle((PropertyStyle)new ForgePropertyStyle(forgePropertyStyleConfig));
        JpaInspector jpaInspector = new JpaInspector(jpaInspectorConfig);
        BeanValidationInspector beanValidationInspector = new BeanValidationInspector(baseObjectInspectorConfig);
        CompositeInspectorConfig compositeInspectorConfig = new CompositeInspectorConfig();
        compositeInspectorConfig.setInspectors(new Inspector[]{propertyTypeInspector, forgeInspector, jpaInspector, beanValidationInspector});
        this.compositeInspector = new CompositeInspector(compositeInspectorConfig);
    }
}

