/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.metawidget.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.jboss.forge.parser.java.EnumConstant;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.scaffoldx.metawidget.inspector.propertystyle.ForgePropertyStyle;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

public class ForgeInspector
extends BaseObjectInspector {
    public ForgeInspector() {
        super(new BaseObjectInspectorConfig());
    }

    public ForgeInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        List<EnumConstant<JavaEnum>> enumConstants;
        HashMap attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(OneToOne.class) || property.isAnnotationPresent(Embedded.class)) {
            attributes.put("one-to-one", "true");
            this.getReversePrimaryKey(property, attributes);
        }
        if (property.isAnnotationPresent(ManyToOne.class)) {
            attributes.put("many-to-one", "true");
            this.getReversePrimaryKey(property, attributes);
        }
        if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class)) {
            attributes.put("n-to-many", "true");
            this.getCollectionReversePrimaryKey(property, attributes);
        }
        if (property instanceof ForgePropertyStyle.ForgeProperty && (enumConstants = ((ForgePropertyStyle.ForgeProperty)property).getEnumConstants()) != null) {
            ArrayList lookup = CollectionUtils.newArrayList();
            for (EnumConstant<JavaEnum> anEnum : enumConstants) {
                lookup.add(anEnum.getName());
            }
            attributes.put("lookup", CollectionUtils.toString((Collection)lookup));
        }
        if (property.isAnnotationPresent(Id.class)) {
            attributes.put("primary-key", "true");
        }
        return attributes;
    }

    private void getReversePrimaryKey(Property property, Map<String, String> attributes) {
        for (Property reverseProperty : this.getProperties(property.getType()).values()) {
            if (!reverseProperty.isAnnotationPresent(Id.class)) continue;
            attributes.put("reverse-primary-key", reverseProperty.getName());
            break;
        }
    }

    private void getCollectionReversePrimaryKey(Property property, Map<String, String> attributes) {
        for (Property reverseProperty : this.getProperties(property.getGenericType()).values()) {
            if (!reverseProperty.isAnnotationPresent(Id.class)) continue;
            attributes.put("reverse-primary-key", reverseProperty.getName());
            break;
        }
    }
}

