/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.freemarker;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.scaffoldx.ScaffoldQualifier;
import org.jboss.forge.scaffoldx.freemarker.TemplateLoaderConfig;

public class FreemarkerClient {
    private Configuration config;

    public FreemarkerClient() {
    }

    @Inject
    public FreemarkerClient(@ScaffoldQualifier Instance<TemplateLoaderConfig> instance) {
        this((TemplateLoaderConfig)instance.get());
    }

    public FreemarkerClient(TemplateLoaderConfig loaderConfig) {
        ArrayList<Object> loaders = new ArrayList<Object>();
        File templateBaseDir = loaderConfig.getTemplateBaseDir();
        if (templateBaseDir != null) {
            try {
                loaders.add(new FileTemplateLoader(templateBaseDir));
            }
            catch (IOException ioEx) {
                throw new RuntimeException(ioEx);
            }
        }
        loaders.add(new ClassTemplateLoader(loaderConfig.getLoaderClass(), loaderConfig.getBasePath()));
        this.config = new Configuration();
        this.config.setTemplateLoader((TemplateLoader)new MultiTemplateLoader(loaders.toArray(new TemplateLoader[0])));
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public String processFTL(Map<String, Object> root, String inputPath) {
        try {
            Template templateFile = this.config.getTemplate(inputPath);
            StringWriter out = new StringWriter();
            templateFile.process(root, (Writer)out);
            ((Writer)out).flush();
            return ((Object)out).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e);
        }
    }
}

