/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.scaffoldx.plugins;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.project.services.FacetFactory;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.scaffoldx.ScaffoldProvider;
import org.jboss.forge.scaffoldx.events.ScaffoldGeneratedResources;
import org.jboss.forge.scaffoldx.plugins.shell.ScaffoldProviderCompleter;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.ConstraintInspector;

@Alias(value="scaffold-x")
@Topic(value="UI Generation & Scaffolding")
@Help(value="Scaffolding projects from a provided set of resources")
@RequiresProject
@RequiresFacet(value={ScaffoldProvider.class})
public class ScaffoldXPlugin
implements Plugin {
    @Inject
    @Current
    private Resource<?> currentResource;
    @Inject
    private Configuration config;
    @Inject
    private Project project;
    @Inject
    private ShellPrompt prompt;
    @Inject
    private ShellPrintWriter writer;
    @Inject
    private Event<ScaffoldGeneratedResources> generatedEvent;
    @Inject
    private Event<InstallFacets> installFacets;
    @Inject
    private FacetFactory factory;

    @SetupCommand
    public void setup(@Option(name="targetDir") String targetDir, @Option(name="scaffoldType", required=false, completer=ScaffoldProviderCompleter.class) String scaffoldType, @Option(flagOnly=true, name="overwrite") boolean overwrite, @Option(name="installTemplates") boolean installTemplates) {
        ScaffoldProvider provider = this.getScaffoldType(scaffoldType, false);
        List generatedResources = provider.setup(targetDir = this.selectTargetDir(provider, targetDir), overwrite, installTemplates);
        if (!generatedResources.isEmpty()) {
            this.generatedEvent.fire((Object)new ScaffoldGeneratedResources(provider, this.prepareResources(generatedResources)));
        }
    }

    @Command(value="from")
    public void generateFromResources(@Option(required=false) Resource<?>[] resources, @Option(name="targetDir") String targetDir, @Option(name="scaffoldType", required=false, completer=ScaffoldProviderCompleter.class) String scaffoldType, @Option(flagOnly=true, name="overwrite") boolean overwrite) throws FileNotFoundException {
        if (resources == null || resources.length < 1) {
            resources = new Resource[]{this.currentResource};
        }
        ScaffoldProvider provider = this.getScaffoldType(scaffoldType, true);
        targetDir = this.selectTargetDir(provider, targetDir);
        List<Resource<?>> resourceList = Arrays.asList(resources);
        List generatedResources = provider.generateFrom(resourceList, targetDir, overwrite);
        if (!generatedResources.isEmpty()) {
            this.generatedEvent.fire((Object)new ScaffoldGeneratedResources(provider, this.prepareResources(generatedResources)));
        }
        ShellMessages.success((ShellPrintWriter)this.writer, (String)("Generated scaffold for [" + resourceList + "]"));
    }

    private String selectTargetDir(ScaffoldProvider provider, String target) {
        if (provider == null) {
            throw new RuntimeException("Selected scaffold provider was null. Re-run with '--scaffoldType ...'");
        }
        String targetDirKey = this.getTargetDirConfigKey(provider);
        if (Strings.isNullOrEmpty((String)target) && Strings.isNullOrEmpty((String)(target = this.config.getString(targetDirKey)))) {
            String finalName = ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getFinalName();
            target = this.prompt.promptCommon("Create scaffold in which sub-directory of web-root? (e.g. http://localhost:8080/" + finalName + "/DIR)", PromptType.FILE_PATH, "/");
        }
        if (!Strings.isNullOrEmpty((String)target)) {
            this.config.setProperty(targetDirKey, (Object)target);
            if (!target.startsWith("/")) {
                target = "/" + target;
            }
            if (target.endsWith("/")) {
                target = target.substring(0, target.length() - 1);
            }
        }
        return target;
    }

    private String getTargetDirConfigKey(ScaffoldProvider provider) {
        return provider.getClass().getName() + "_targetDir";
    }

    private ScaffoldProvider getScaffoldType(String scaffoldType, boolean invokedViaGeneration) {
        FileResource favicon;
        ScaffoldProvider scaffoldImpl = null;
        Collection facets = this.project.getFacets();
        ArrayList<ScaffoldProvider> detectedScaffolds = new ArrayList<ScaffoldProvider>();
        for (Facet facet : facets) {
            if (!(facet instanceof ScaffoldProvider)) continue;
            detectedScaffolds.add((ScaffoldProvider)facet);
            if (!ConstraintInspector.getName(facet.getClass()).equals(scaffoldType)) continue;
            scaffoldImpl = (ScaffoldProvider)facet;
        }
        if (invokedViaGeneration && scaffoldImpl == null) {
            ArrayList<String> detectedScaffoldNames = new ArrayList<String>();
            for (ScaffoldProvider sp : detectedScaffolds) {
                detectedScaffoldNames.add(ConstraintInspector.getName(sp.getClass()));
            }
            if (detectedScaffolds.size() > 1) {
                String name = (String)this.prompt.promptChoiceTyped("Use which previously installed scaffold provider?", detectedScaffoldNames, detectedScaffoldNames.get(detectedScaffoldNames.size() - 1));
                for (ScaffoldProvider sp : detectedScaffolds) {
                    if (!name.equals(ConstraintInspector.getName(sp.getClass()))) continue;
                    scaffoldImpl = sp;
                    break;
                }
            } else if (!detectedScaffolds.isEmpty()) {
                scaffoldImpl = (ScaffoldProvider)detectedScaffolds.get(0);
                ShellMessages.info((ShellPrintWriter)this.writer, (String)("Using currently installed scaffold [" + ConstraintInspector.getName(scaffoldImpl.getClass()) + "]"));
            }
        }
        HashSet<Class> providers = new HashSet<Class>();
        for (Class type : this.factory.getFacetTypes()) {
            if (!ScaffoldProvider.class.isAssignableFrom(type)) continue;
            providers.add(type);
        }
        if (scaffoldImpl == null && scaffoldType == null && this.prompt.promptBoolean("No scaffold type was selected, use default [JavaServer Faces]?")) {
            scaffoldType = "faces";
            for (Class type : providers) {
                if (!ConstraintInspector.getName((Class)type).equals(scaffoldType)) continue;
                scaffoldImpl = (ScaffoldProvider)this.factory.getFacet(type);
            }
        } else if (scaffoldImpl == null && scaffoldType != null) {
            for (Class type : providers) {
                if (!ConstraintInspector.getName((Class)type).equals(scaffoldType)) continue;
                scaffoldImpl = (ScaffoldProvider)this.factory.getFacet(type);
            }
        }
        if (scaffoldImpl == null) {
            throw new RuntimeException("No scaffold installed was detected, and no scaffold type was selected; re-run with '--scaffoldType ...' ");
        }
        if (!this.project.hasFacet(scaffoldImpl.getClass()) && this.prompt.promptBoolean("Scaffold provider [" + scaffoldType + "] is not installed. Install it?")) {
            this.project.setAttribute("installing-scaffold", (Object)Boolean.TRUE);
            this.installFacets.fire((Object)new InstallFacets(scaffoldImpl.getClass()));
            this.project.removeAttribute("installing-scaffold");
        } else if (!this.project.hasFacet(scaffoldImpl.getClass())) {
            throw new RuntimeException("Aborted.");
        }
        if (this.project.hasFacet(WebResourceFacet.class) && !(favicon = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebResource("/favicon.ico")).exists()) {
            favicon.setContents(this.getClass().getResourceAsStream("/org/jboss/forge/scaffoldx/favicon.ico"));
        }
        return (ScaffoldProvider)this.project.getFacet(scaffoldImpl.getClass());
    }

    private List<Resource<?>> prepareResources(List<Resource<?>> generatedResources) {
        ArrayList<Integer> nullIndexes = new ArrayList<Integer>();
        for (int i = 0; i < generatedResources.size(); ++i) {
            Resource<?> r = generatedResources.get(i);
            if (r != null) continue;
            nullIndexes.add(i);
        }
        for (Integer index : nullIndexes) {
            generatedResources.remove(index);
        }
        return generatedResources;
    }
}

