/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;

public class ColumnPrinter {
    protected OutputAttributes calculateOutputAttributes(List<String> rawList, Shell shell, OutputAttributes in) {
        if (in == null) {
            return this.calculateOutputAttributes(rawList, shell);
        }
        OutputAttributes newAttr = this.calculateOutputAttributes(rawList, shell);
        return new OutputAttributes(in.columnSize > newAttr.columnSize ? in.columnSize : newAttr.columnSize, in.columns < newAttr.columns ? in.columns : newAttr.columns);
    }

    protected OutputAttributes calculateOutputAttributes(List<String> rawList, Shell shell) {
        int colSize;
        int width = shell.getWidth();
        int maxLength = 0;
        for (String s : rawList) {
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
        }
        int cols = width / (maxLength + 4);
        if (cols == 0) {
            colSize = width;
            cols = 1;
        } else {
            colSize = width / cols;
        }
        return new OutputAttributes(colSize, cols);
    }

    public void printOutColumns(List<String> rawList, ShellPrintWriter out, Shell shell, boolean sort) {
        this.printOutColumns(rawList, ShellColor.NONE, out, this.calculateOutputAttributes(rawList, shell), null, sort);
    }

    protected void printOutColumns(List<String> rawList, ShellPrintWriter out, Shell shell, FormatCallback callback, boolean sort) {
        this.printOutColumns(rawList, ShellColor.NONE, out, this.calculateOutputAttributes(rawList, shell), callback, sort);
    }

    protected void printOutColumns(List<String> rawList, ShellColor color, ShellPrintWriter printWriter, OutputAttributes attributes, FormatCallback callback, boolean sort) {
        if (sort) {
            Collections.sort(rawList);
        }
        int cols = attributes.columns;
        int colSize = attributes.columnSize;
        int i = 0;
        for (String s : rawList) {
            String out;
            String string = out = callback != null ? callback.format(0, s) : s;
            if (color == ShellColor.NONE) {
                printWriter.print(out);
            } else {
                printWriter.print(color, out);
            }
            if (++i != cols) {
                printWriter.print(this.pad(colSize - s.length()));
            }
            if (i != cols) continue;
            printWriter.println();
            i = 0;
        }
        if (i != 0 && i != cols) {
            printWriter.println();
        }
    }

    public void printOutTables(List<String> list, int cols, Shell shell) {
        this.printOutTables(list, new boolean[cols], shell, null);
    }

    public void printOutTables(List<String> list, boolean[] columns, Shell shell) {
        this.printOutTables(list, columns, shell, null);
    }

    protected void printOutTables(List<String> list, boolean[] columns, ShellPrintWriter shell, FormatCallback callback) {
        String el;
        int i;
        int cols = columns.length;
        int[] colSizes = new int[columns.length];
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            for (i = 0; i < cols; ++i) {
                el = iter.next();
                if (colSizes[i] >= el.length()) continue;
                colSizes[i] = el.length();
            }
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            for (i = 0; i < cols; ++i) {
                el = iter.next();
                if (columns[i]) {
                    shell.print(this.pad(colSizes[i] - el.length()));
                    if (callback != null) {
                        shell.print(callback.format(i, el));
                    } else {
                        shell.print(el);
                    }
                    if (!iter.hasNext()) continue;
                    shell.print(" ");
                    continue;
                }
                if (callback != null) {
                    shell.print(callback.format(i, el));
                } else {
                    shell.print(el);
                }
                if (!iter.hasNext()) continue;
                shell.print(this.pad(colSizes[i] - el.length()));
                shell.print(" ");
            }
            shell.println();
        }
    }

    protected String pad(int amount) {
        char[] padding = new char[amount];
        for (int i = 0; i < amount; ++i) {
            padding[i] = 32;
        }
        return new String(padding);
    }

    protected static class OutputAttributes {
        private final int columnSize;
        private final int columns;

        public OutputAttributes(int columnSize, int columns) {
            this.columnSize = columnSize;
            this.columns = columns;
        }
    }

    protected static interface FormatCallback {
        public String format(int var1, String var2);
    }
}

