/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.util.HashSet;
import java.util.Set;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;

public class JavaColorizer {
    public static final ShellColor CLR_ANNOTATION = ShellColor.YELLOW;
    public static final ShellColor CLR_STR_LITERAL = ShellColor.GREEN;
    public static final ShellColor CLR_KEYWORD = ShellColor.BLUE;
    public static final ShellColor CLR_COMMENT = ShellColor.CYAN;
    private static final Set<String> LITERALS = new HashSet<String>();

    public static String format(ShellPrintWriter writer, String in) {
        StringBuilder output = new StringBuilder("");
        char[] arr = in.toCharArray();
        int start = 0;
        boolean capture = false;
        for (int cursor = 0; cursor < arr.length; ++cursor) {
            if (Character.isWhitespace(arr[cursor])) {
                if (capture) {
                    JavaColorizer.doCapture(writer, arr, output, start, cursor);
                    capture = false;
                }
            } else if (arr[cursor] == '\"' || arr[cursor] == '\'') {
                if (capture) {
                    output.append(JavaColorizer.getHTMLizedString(arr, start, cursor - start));
                    capture = false;
                }
                start = cursor;
                cursor = JavaColorizer.balancedCapture(arr, start, arr[cursor]);
                output.append(writer.renderColor(CLR_STR_LITERAL, JavaColorizer.getHTMLizedString(arr, start, ++cursor - start)));
            } else if (!capture) {
                if (Character.isJavaIdentifierPart(arr[cursor])) {
                    capture = true;
                    start = cursor;
                } else if (arr[cursor] == '/') {
                    String comment;
                    start = cursor++;
                    if (arr[cursor] == '/') {
                        while (cursor != arr.length && arr[cursor] != '\n') {
                            ++cursor;
                        }
                        comment = JavaColorizer.getHTMLizedString(arr, start, ++cursor - start + 1);
                        output.append(writer.renderColor(CLR_COMMENT, comment));
                        ++cursor;
                    } else if (arr[cursor] == '*') {
                        while (cursor != arr.length && (arr[cursor] != '*' || arr[cursor + 1] != '/')) {
                            ++cursor;
                        }
                        comment = JavaColorizer.getHTMLizedString(arr, start, ++cursor - start + 1);
                        output.append(writer.renderColor(CLR_COMMENT, comment));
                        ++cursor;
                    } else {
                        output.append(arr, start, cursor - start);
                    }
                } else if (arr[cursor] == '@') {
                    start = cursor++;
                    while (cursor != arr.length && Character.isJavaIdentifierPart(arr[cursor])) {
                        ++cursor;
                    }
                    String token = new String(arr, start, cursor - start);
                    output.append(writer.renderColor(CLR_ANNOTATION, token));
                }
            }
            if (arr[cursor] == '(') {
                if (capture) {
                    JavaColorizer.doCapture(writer, arr, output, start, cursor);
                    capture = false;
                }
                output.append(arr[cursor]);
                continue;
            }
            if (capture) continue;
            output.append(arr[cursor]);
        }
        if (capture) {
            JavaColorizer.doCapture(writer, arr, output, start, arr.length);
            capture = false;
        }
        return output.toString();
    }

    private static String getHTMLizedString(char[] arr, int start, int length) {
        return new String(arr, start, length);
    }

    private static void doCapture(ShellPrintWriter writer, char[] arr, StringBuilder output, int start, int cursor) {
        String tk = new String(arr, start, cursor - start).trim();
        if (LITERALS.contains(tk)) {
            output.append(writer.renderColor(CLR_KEYWORD, tk));
        } else {
            output.append(tk);
        }
    }

    private static int balancedCapture(char[] chars, int start, char type) {
        int depth = 1;
        char term = type;
        switch (type) {
            case '[': {
                term = ']';
                break;
            }
            case '{': {
                term = '}';
                break;
            }
            case '(': {
                term = ')';
            }
        }
        if (type == term) {
            ++start;
            while (start < chars.length) {
                if (chars[start] == type) {
                    return start;
                }
                ++start;
            }
        } else {
            ++start;
            while (start < chars.length) {
                if (start < chars.length && chars[start] == '/') {
                    if (start + 1 == chars.length) {
                        return start;
                    }
                    if (chars[start + 1] == '/') {
                        ++start;
                        while (start < chars.length && chars[start] != '\n') {
                            ++start;
                        }
                    } else if (chars[start + 1] == '*') {
                        start += 2;
                        while (start < chars.length) {
                            switch (chars[start]) {
                                case '*': {
                                    if (start + 1 >= chars.length || chars[start + 1] != '/') break;
                                    break;
                                }
                            }
                            ++start;
                        }
                    }
                }
                if (start == chars.length) {
                    return start;
                }
                if (chars[start] == '\'' || chars[start] == '\"') {
                    start = JavaColorizer.captureStringLiteral(chars[start], chars, start, chars.length);
                } else if (chars[start] == type) {
                    ++depth;
                } else if (chars[start] == term && --depth == 0) {
                    return start;
                }
                ++start;
            }
        }
        return start;
    }

    private static int captureStringLiteral(char type, char[] expr, int cursor, int length) {
        while (++cursor < length && expr[cursor] != type) {
            if (expr[cursor] != '\\') continue;
            ++cursor;
        }
        return cursor;
    }

    static {
        LITERALS.add("public");
        LITERALS.add("private");
        LITERALS.add("protected");
        LITERALS.add("final");
        LITERALS.add("void");
        LITERALS.add("class");
        LITERALS.add("interface");
        LITERALS.add("static");
        LITERALS.add("package");
        LITERALS.add("import");
        LITERALS.add("implements");
        LITERALS.add("extends");
        LITERALS.add("try");
        LITERALS.add("catch");
        LITERALS.add("finally");
        LITERALS.add("while");
        LITERALS.add("for");
        LITERALS.add("if");
        LITERALS.add("else");
        LITERALS.add("true");
        LITERALS.add("false");
        LITERALS.add("new");
        LITERALS.add("this");
        LITERALS.add("switch");
        LITERALS.add("case");
        LITERALS.add("break");
        LITERALS.add("continue");
        LITERALS.add("return");
        LITERALS.add("throw");
        LITERALS.add("volatile");
        LITERALS.add("synchronized");
        LITERALS.add("null");
    }
}

