/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.bus.util.Annotations;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.AliasLiteral;
import org.jboss.forge.shell.project.FacetRegistry;
import org.jboss.forge.shell.util.BeanManagerUtils;
import org.jboss.forge.shell.util.ConstraintInspector;

@Dependent
public class FacetFactory {
    private List<Facet> facets;
    private FacetRegistry registry;
    private BeanManager bm;

    @Inject
    public FacetFactory(FacetRegistry registry, BeanManager bm) {
        this.registry = registry;
        this.bm = bm;
    }

    public Set<Class<? extends Facet>> getFacetTypes() {
        return this.registry.getFacetTypes();
    }

    @Deprecated
    public List<Facet> getFacets() {
        if (this.facets == null) {
            Iterator<Class<? extends Facet>> iterator = this.getFacetTypes().iterator();
            ArrayList<Facet> result = new ArrayList<Facet>();
            while (iterator.hasNext()) {
                result.add(this.getFacet(iterator.next()));
            }
            this.facets = result;
        }
        return this.facets;
    }

    public <T extends Facet> T getFacet(Class<T> type) throws FacetNotFoundException {
        Facet result = null;
        for (Class<? extends Facet> facetType : this.getFacetTypes()) {
            if (type.isAssignableFrom(facetType)) {
                result = Annotations.isAnnotationPresent(facetType, Alias.class) ? BeanManagerUtils.getContextualInstance(this.bm, facetType, new AliasLiteral(ConstraintInspector.getName(facetType))) : BeanManagerUtils.getContextualInstance(this.bm, facetType);
            }
            if (!type.equals(facetType)) continue;
            if (Annotations.isAnnotationPresent(facetType, Alias.class)) {
                result = BeanManagerUtils.getContextualInstance(this.bm, facetType, new AliasLiteral(ConstraintInspector.getName(facetType)));
                break;
            }
            result = BeanManagerUtils.getContextualInstance(this.bm, facetType);
            break;
        }
        if (result == null) {
            throw new FacetNotFoundException("The requested Facet of type [" + type.getName() + "] could not be loaded.");
        }
        return (T)result;
    }

    public Facet getFacetByName(String facetName) throws FacetNotFoundException {
        Facet result = null;
        for (Class<? extends Facet> facet : this.getFacetTypes()) {
            String name = ConstraintInspector.getName(facet);
            if (!name.equals(facetName)) continue;
            result = this.getFacet(facet);
            break;
        }
        if (result == null) {
            throw new FacetNotFoundException("The requested Facet named [" + facetName + "] could not be found.");
        }
        return result;
    }
}

