/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.PathspecParser;

@Alias(value="cp")
@Topic(value="File & Resources")
@RequiresResource(value={DirectoryResource.class})
@Help(value="Copy a file or directory")
public class CopyPlugin
implements Plugin {
    @Inject
    @Current
    Resource<?> directory;
    private final ResourceFactory resourceFactory;

    @Inject
    public CopyPlugin(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    @DefaultCommand
    public void copy(@Option(description="source", required=true) Resource<?> source, @Option(description="target", required=true) String target) {
        if (this.isDirectory(source)) {
            this.copyRecursively(source, this.directory, target);
        } else if (this.isFile(source)) {
            this.copy(source, this.directory, target);
        } else {
            throw new RuntimeException("cannot copy resource type: " + source.getClass().getSimpleName());
        }
    }

    private void copy(Resource<?> source, Resource<?> directory, String target) {
        List results = new PathspecParser(this.resourceFactory, directory, target).resolve();
        if (results.size() > 1) {
            throw new RuntimeException("ambiguous target file name: " + target);
        }
        Resource targetResource = (Resource)results.get(0);
        if (targetResource.exists() && this.isDirectory(targetResource)) {
            targetResource = targetResource.getChild(source.getName());
        }
        ((FileResource)targetResource).setContents(source.getResourceInputStream());
    }

    private void copyRecursively(Resource<?> source, Resource<?> directory, String target) {
        List results = new PathspecParser(this.resourceFactory, directory, target).resolve();
        if (results.size() > 1) {
            throw new RuntimeException("ambiguous target file name: " + target);
        }
        Resource targetResource = (Resource)results.get(0);
        DirectoryResource newTargetDir = null;
        if (this.isDirectory(source)) {
            newTargetDir = !targetResource.exists() ? ((DirectoryResource)targetResource.getParent()).getOrCreateChildDirectory(targetResource.getName()) : ((DirectoryResource)targetResource).getOrCreateChildDirectory(source.getName());
            for (Resource resource : source.listResources()) {
                this.copyRecursively(resource, directory, newTargetDir.getFullyQualifiedName());
            }
        } else if (this.isFile(source)) {
            Resource child = targetResource.getChild(source.getName());
            if (child == null) {
                ((DirectoryResource)targetResource).getOrCreateChildDirectory(source.getName()).setContents(source.getResourceInputStream());
            } else {
                ((FileResource)child).setContents(source.getResourceInputStream());
            }
            newTargetDir = targetResource;
        }
    }

    private boolean isFile(Resource<?> source) {
        return source instanceof FileResource;
    }

    private boolean isDirectory(Resource<?> source) {
        return source instanceof DirectoryResource;
    }
}

