/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.java.JavaFieldResource;
import org.jboss.forge.resources.java.JavaMemberResource;
import org.jboss.forge.resources.java.JavaMethodResource;
import org.jboss.forge.resources.java.JavaResource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.GeneralUtils;
import org.jboss.forge.shell.util.JavaColorizer;

@Alias(value="ls")
@RequiresResource(value={JavaResource.class, JavaMethodResource.class, JavaFieldResource.class})
@Topic(value="File & Resources")
@Help(value="Prints the contents current Java file")
public class LsJavaPlugin
implements Plugin {
    private static final String DELIM = "::";
    @Inject
    private Shell shell;

    @DefaultCommand
    public void run(@Option(description="path", defaultValue=".") Resource<?>[] paths, @Option(flagOnly=true, name="all", shortName="a", required=false) boolean showAll, @Option(flagOnly=true, name="list", shortName="l", required=false) boolean list, PipeOut out) throws FileNotFoundException {
        for (Resource<?> resource : paths) {
            if (resource instanceof JavaResource) {
                GeneralUtils.OutputAttributes attr;
                String entry;
                if (showAll) {
                    out.print(JavaColorizer.format((ShellPrintWriter)out, (String)((JavaResource)resource).getJavaSource().toString()));
                    continue;
                }
                JavaResource javaResource = (JavaResource)resource;
                JavaSource javaSource = javaResource.getJavaSource();
                ArrayList<String> output = new ArrayList<String>();
                if (!out.isPiped()) {
                    out.println();
                    out.println(ShellColor.RED, "[fields]");
                }
                if (javaSource instanceof JavaClass) {
                    JavaClass javaClass = (JavaClass)javaSource;
                    List fields = javaClass.getFields();
                    for (Field field : fields) {
                        entry = out.renderColor(ShellColor.BLUE, field.getVisibility().scope());
                        entry = entry + out.renderColor(ShellColor.GREEN, DELIM + field.getType() + "");
                        entry = entry + DELIM + field.getName() + ";";
                        output.add(entry);
                    }
                    if (out.isPiped()) {
                        attr = new GeneralUtils.OutputAttributes(120, 1);
                        GeneralUtils.printOutColumns(output, ShellColor.NONE, (ShellPrintWriter)out, attr, null, false);
                    } else {
                        GeneralUtils.printOutColumns(output, (ShellPrintWriter)out, this.shell, true);
                        out.println();
                    }
                    output = new ArrayList();
                    List methods = javaClass.getMethods();
                    if (!out.isPiped()) {
                        out.println(ShellColor.RED, "[methods]");
                    }
                    for (Method method : methods) {
                        String entry2 = out.renderColor(ShellColor.BLUE, method.getVisibility().scope());
                        String parameterString = "(";
                        for (Parameter param : method.getParameters()) {
                            parameterString = parameterString + param.toString();
                        }
                        parameterString = parameterString + ")";
                        entry2 = entry2 + DELIM + method.getName() + parameterString;
                        String returnType = method.getReturnType() == null ? "void" : method.getReturnType();
                        entry2 = entry2 + out.renderColor(ShellColor.GREEN, DELIM + returnType + "");
                        output.add(entry2);
                    }
                    if (out.isPiped()) {
                        GeneralUtils.OutputAttributes attr2 = new GeneralUtils.OutputAttributes(120, 1);
                        GeneralUtils.printOutColumns(output, ShellColor.NONE, (ShellPrintWriter)out, attr2, null, false);
                        continue;
                    }
                    GeneralUtils.printOutColumns(output, (ShellPrintWriter)out, this.shell, true);
                    out.println();
                    continue;
                }
                if (!(javaSource instanceof JavaEnum)) continue;
                JavaResource enumTypeResource = (JavaResource)resource;
                List members = enumTypeResource.listResources();
                for (Resource member : members) {
                    entry = member.getName();
                    output.add(entry);
                }
                if (out.isPiped()) {
                    attr = new GeneralUtils.OutputAttributes(120, 1);
                    GeneralUtils.printOutColumns(output, ShellColor.NONE, (ShellPrintWriter)out, attr, null, false);
                    continue;
                }
                GeneralUtils.printOutColumns(output, (ShellPrintWriter)out, this.shell, true);
                out.println();
                continue;
            }
            if (!(resource instanceof JavaMemberResource)) continue;
            out.println();
            out.println(JavaColorizer.format((ShellPrintWriter)out, (String)resource.toString()));
        }
    }
}

