/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project;

import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.project.Project;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.events.InitProject;
import org.jboss.forge.shell.events.ProjectChanged;
import org.jboss.forge.shell.project.ProjectScoped;
import org.jboss.forge.shell.project.resources.CurrentResource;

@Singleton
public class CurrentProject {
    private Project currentProject;
    @Inject
    private CurrentResource currentResource;
    @Inject
    private Event<InitProject> init;
    @Inject
    private Event<ProjectChanged> projectChanged;

    @Produces
    @Default
    @ProjectScoped
    public Project getCurrent() {
        return this.currentProject;
    }

    public void setCurrentProject(Project project) {
        if (project != null && this.currentProject != null) {
            DirectoryResource newRoot;
            DirectoryResource currentRoot = this.currentProject.getProjectRoot();
            if (!currentRoot.equals((Object)(newRoot = project.getProjectRoot()))) {
                this.changeProject(this.currentProject, project);
            } else {
                this.currentProject = project;
            }
        } else if (project != null && this.currentProject == null || project == null && this.currentProject != null) {
            this.changeProject(this.currentProject, project);
        }
    }

    private void changeProject(Project currentProject, Project project) {
        ProjectChanged event = new ProjectChanged(currentProject, project);
        this.currentProject = project;
        this.projectChanged.fire((Object)event);
    }

    public void setCurrentResource(Resource<?> resource) {
        this.currentResource.setCurrent(resource);
        this.init.fire((Object)new InitProject());
    }

    public Resource<?> getCurrentResource() {
        return this.currentResource.getCurrent();
    }
}

