/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.util.FormatCallback;
import org.jboss.forge.shell.util.ResourceUtil;

public class GeneralUtils {
    public static <T> T[] join(Class<T> type, T[] front, T ... back) {
        Assert.notNull(type, (String)"Type must not be null.");
        Assert.notNull(front, (String)"Target array must not be null.");
        Assert.notNull(back, (String)"Source array must not be null.");
        Object[] dest = front;
        int size = 0;
        if (front != null) {
            size = front.length;
        }
        if (back != null) {
            size += back.length;
        }
        if ((dest = (Object[])Array.newInstance(type, size)).length > 1) {
            System.arraycopy(front, 0, dest, 0, front.length);
            System.arraycopy(back, 0, dest, front.length, back.length);
        }
        return dest;
    }

    public static <T> List<T> concatArraysToList(T[] ... arrays) {
        ArrayList<T> newList = new ArrayList<T>();
        for (T[] elArray : arrays) {
            newList.addAll(Arrays.asList(elArray));
        }
        return newList;
    }

    public static String elementListSimpleTypesToString(List<Class<?>> list) {
        StringBuilder sbuild = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sbuild.append(list.get(0).getSimpleName());
            if (i >= list.size()) continue;
            sbuild.append(", ");
        }
        return sbuild.toString();
    }

    public static String elementSetSimpleTypesToString(Set<Class<?>> set) {
        StringBuilder sbuild = new StringBuilder();
        Iterator<Class<?>> iter = set.iterator();
        while (iter.hasNext()) {
            sbuild.append(iter.next().getSimpleName());
            if (!iter.hasNext()) continue;
            sbuild.append(", ");
        }
        return sbuild.toString();
    }

    public static OutputAttributes calculateOutputAttributs(List<String> rawList, Shell shell, OutputAttributes in) {
        if (in == null) {
            return GeneralUtils.calculateOutputAttributs(rawList, shell);
        }
        OutputAttributes newAttr = GeneralUtils.calculateOutputAttributs(rawList, shell);
        return new OutputAttributes(in.columnSize > newAttr.columnSize ? in.columnSize : newAttr.columnSize, in.columns < newAttr.columns ? in.columns : newAttr.columns);
    }

    public static OutputAttributes calculateOutputAttributs(List<String> rawList, Shell shell) {
        int colSize;
        int width = shell.getWidth();
        int maxLength = 0;
        for (String s : rawList) {
            if (s.length() <= maxLength) continue;
            maxLength = s.length();
        }
        int cols = width / (maxLength + 4);
        if (cols == 0) {
            colSize = width;
            cols = 1;
        } else {
            colSize = width / cols;
        }
        return new OutputAttributes(colSize, cols);
    }

    public static void printOutColumns(List<String> rawList, ShellPrintWriter out, Shell shell, boolean sort) {
        GeneralUtils.printOutColumns(rawList, ShellColor.NONE, out, GeneralUtils.calculateOutputAttributs(rawList, shell), null, sort);
    }

    public static void printOutColumns(List<String> rawList, ShellPrintWriter out, Shell shell, FormatCallback callback, boolean sort) {
        GeneralUtils.printOutColumns(rawList, ShellColor.NONE, out, GeneralUtils.calculateOutputAttributs(rawList, shell), callback, sort);
    }

    public static void printOutColumns(List<String> rawList, ShellColor color, ShellPrintWriter printWriter, OutputAttributes attributes, FormatCallback callback, boolean sort) {
        if (sort) {
            Collections.sort(rawList);
        }
        int cols = attributes.columns;
        int colSize = attributes.columnSize;
        int i = 0;
        for (String s : rawList) {
            String out;
            String string = out = callback != null ? callback.format(0, s) : s;
            if (color == ShellColor.NONE) {
                printWriter.print(out);
            } else {
                printWriter.print(color, out);
            }
            if (++i != cols) {
                printWriter.print(GeneralUtils.pad(colSize - s.length()));
            }
            if (i != cols) continue;
            printWriter.println();
            i = 0;
        }
        if (i != 0 && i != cols) {
            printWriter.println();
        }
    }

    public static void printOutTables(List<String> list, int cols, Shell shell) {
        GeneralUtils.printOutTables(list, new boolean[cols], (ShellPrintWriter)shell, null);
    }

    public static void printOutTables(List<String> list, boolean[] columns, Shell shell) {
        GeneralUtils.printOutTables(list, columns, (ShellPrintWriter)shell, null);
    }

    public static void printOutTables(List<String> list, boolean[] columns, ShellPrintWriter shell, FormatCallback callback) {
        String el;
        int i;
        int cols = columns.length;
        int[] colSizes = new int[columns.length];
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            for (i = 0; i < cols; ++i) {
                el = iter.next();
                if (colSizes[i] >= el.length()) continue;
                colSizes[i] = el.length();
            }
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            for (i = 0; i < cols; ++i) {
                el = iter.next();
                if (columns[i]) {
                    shell.print(GeneralUtils.pad(colSizes[i] - el.length()));
                    if (callback != null) {
                        shell.print(callback.format(i, el));
                    } else {
                        shell.print(el);
                    }
                    if (!iter.hasNext()) continue;
                    shell.print(" ");
                    continue;
                }
                if (callback != null) {
                    shell.print(callback.format(i, el));
                } else {
                    shell.print(el);
                }
                if (!iter.hasNext()) continue;
                shell.print(GeneralUtils.pad(colSizes[i] - el.length()));
                shell.print(" ");
            }
            shell.println();
        }
    }

    public static String pad(int amount) {
        char[] padding = new char[amount];
        for (int i = 0; i < amount; ++i) {
            padding[i] = 32;
        }
        return new String(padding);
    }

    public static Resource<?>[] parseSystemPathspec(ResourceFactory resourceFactory, Resource<?> lastResource, Resource<?> currentResource, String[] paths) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (String path : paths) {
            if ("-".equals(path)) {
                result.add(lastResource == null ? currentResource : lastResource);
                continue;
            }
            if (path == null) {
                result.add(new DirectoryResource(resourceFactory, new File(System.getProperty("user.home"))));
                continue;
            }
            result.addAll(ResourceUtil.parsePathspec((ResourceFactory)resourceFactory, currentResource, (String)path));
        }
        return result.toArray(new Resource[result.size()]);
    }

    public static String pathspecToRegEx(String pathSpec) {
        StringBuilder sb = new StringBuilder("^");
        block5: for (int i = 0; i < pathSpec.length(); ++i) {
            char c = pathSpec.charAt(i);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    continue block5;
                }
                case '*': {
                    sb.append(".*");
                    continue block5;
                }
                case '?': {
                    sb.append(".");
                    continue block5;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append("$").toString();
    }

    public static class OutputAttributes {
        private final int columnSize;
        private final int columns;

        public OutputAttributes(int columnSize, int columns) {
            this.columnSize = columnSize;
            this.columns = columns;
        }
    }
}

