/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.addons;

import java.util.Arrays;
import java.util.List;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;

public class AddonId
implements Comparable<AddonId> {
    private String name;
    private Version apiVersion;
    private Version version;

    public String getName() {
        return this.name;
    }

    public Version getApiVersion() {
        return this.apiVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return this.toCoordinates();
    }

    public static AddonId valueOf(String coordinates) {
        return AddonId.fromCoordinates(coordinates);
    }

    public static AddonId fromCoordinates(String coordinates) throws IllegalArgumentException {
        String[] split = coordinates.split(",");
        List<String> tokens = Arrays.asList(split);
        if (tokens.size() < 2) {
            throw new IllegalArgumentException("Coordinates must be of the form 'name,version' or 'name,version,api-version");
        }
        if (tokens.size() == 3) {
            if (tokens.get(2) == null || tokens.get(2).isEmpty()) {
                throw new IllegalArgumentException("API version was empty [" + coordinates + "]");
            }
            return AddonId.from(tokens.get(0), tokens.get(1), tokens.get(2));
        }
        return AddonId.from(tokens.get(0), tokens.get(1));
    }

    public static AddonId from(String name, String version) {
        return AddonId.from(name, version, null);
    }

    public static AddonId from(String name, Version version) {
        return AddonId.from(name, version, null);
    }

    public static AddonId from(String name, Version version, Version apiVersion) {
        Assert.notNull(name, "Name cannot be null.");
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        Assert.notNull(version, "Version cannot be null.");
        if (version.toString().trim().isEmpty()) {
            throw new IllegalArgumentException("Version cannot be empty.");
        }
        AddonId id = new AddonId();
        id.name = name;
        id.version = version;
        id.apiVersion = apiVersion == null || apiVersion.toString().trim().isEmpty() ? EmptyVersion.getInstance() : apiVersion;
        return id;
    }

    public static AddonId from(String name, String version, String apiVersion) {
        Assert.notNull(name, "Name cannot be null.");
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty.");
        }
        Assert.notNull(version, "Version cannot be null.");
        if (version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version cannot be empty.");
        }
        AddonId id = new AddonId();
        id.name = name;
        id.version = new SingleVersion(version);
        id.apiVersion = apiVersion == null || apiVersion.trim().isEmpty() ? EmptyVersion.getInstance() : new SingleVersion(apiVersion);
        return id;
    }

    public String toCoordinates() {
        StringBuilder coord = new StringBuilder(this.getName()).append(",").append(this.getVersion());
        return coord.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonId)) {
            return false;
        }
        AddonId other = (AddonId)obj;
        if (this.name == null ? other.getName() != null : !this.name.equals(other.getName())) {
            return false;
        }
        return !(this.version == null ? other.getVersion() != null : !this.version.equals(other.getVersion()));
    }

    @Override
    public int compareTo(AddonId other) {
        if (other == null) {
            throw new IllegalArgumentException("Cannot compare against null.");
        }
        int result = this.getName().compareTo(other.getName());
        if (result == 0) {
            result = this.getVersion().compareTo(other.getVersion());
        }
        if (result == 0) {
            result = this.getApiVersion().compareTo(other.getApiVersion());
        }
        return result;
    }
}

