/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven.addon;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;

public class AddonInfoBuilder
implements AddonInfo {
    private final AddonId addon;
    private final Map<AddonInfo, Boolean> requiredAddons = new HashMap<AddonInfo, Boolean>();
    private final Map<AddonInfo, Boolean> optionalAddons = new HashMap<AddonInfo, Boolean>();
    private final Set<File> resources = new HashSet<File>();

    private AddonInfoBuilder(AddonId addon) {
        this.addon = addon;
    }

    public static AddonInfoBuilder from(AddonId addonId) {
        AddonInfoBuilder builder = new AddonInfoBuilder(addonId);
        return builder;
    }

    public AddonInfoBuilder addRequiredDependency(AddonInfo addonInfo, boolean exported) {
        this.requiredAddons.put(addonInfo, exported);
        return this;
    }

    public AddonInfoBuilder addOptionalDependency(AddonInfo addonInfo, boolean exported) {
        this.optionalAddons.put(addonInfo, exported);
        return this;
    }

    public AddonInfoBuilder addResource(File file) {
        this.resources.add(file);
        return this;
    }

    public AddonId getAddon() {
        return this.addon;
    }

    public Set<AddonInfo> getOptionalAddons() {
        return Collections.unmodifiableSet(this.optionalAddons.keySet());
    }

    public Set<AddonInfo> getRequiredAddons() {
        return Collections.unmodifiableSet(this.requiredAddons.keySet());
    }

    public Set<File> getResources() {
        return Collections.unmodifiableSet(this.resources);
    }

    public Set<AddonDependencyEntry> getDependencyEntries() {
        Boolean exported;
        AddonId key;
        HashSet<AddonDependencyEntry> entries = new HashSet<AddonDependencyEntry>();
        for (Map.Entry<AddonInfo, Boolean> entry : this.requiredAddons.entrySet()) {
            key = entry.getKey().getAddon();
            exported = entry.getValue();
            entries.add(AddonDependencyEntry.create((String)key.getName(), (String)key.getVersion().toString(), (boolean)exported, (boolean)false));
        }
        for (Map.Entry<AddonInfo, Boolean> entry : this.optionalAddons.entrySet()) {
            key = entry.getKey().getAddon();
            exported = entry.getValue();
            entries.add(AddonDependencyEntry.create((String)key.getName(), (String)key.getVersion().toString(), (boolean)exported, (boolean)true));
        }
        return entries;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addon == null ? 0 : this.addon.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddonInfo)) {
            return false;
        }
        AddonInfo other = (AddonInfo)obj;
        return !(this.addon == null ? other.getAddon() != null : !this.addon.equals((Object)other.getAddon()));
    }

    public String toString() {
        return this.addon.toString();
    }
}

