/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven.addon;

import java.io.File;
import java.util.Set;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.maven.addon.AddonInfoBuilder;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.manager.spi.Response;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;

class LazyAddonInfo
implements AddonInfo {
    private final AddonDependencyResolver resolver;
    private AddonInfoBuilder builder;

    public LazyAddonInfo(AddonDependencyResolver resolver, AddonInfoBuilder builder) {
        this.resolver = resolver;
        this.builder = builder;
    }

    public Set<File> getResources() {
        this.resolveResources(this.builder);
        return this.builder.getResources();
    }

    public Set<AddonInfo> getRequiredAddons() {
        return this.builder.getRequiredAddons();
    }

    public Set<AddonInfo> getOptionalAddons() {
        return this.builder.getOptionalAddons();
    }

    public AddonId getAddon() {
        return this.builder.getAddon();
    }

    public Set<AddonDependencyEntry> getDependencyEntries() {
        return this.builder.getDependencyEntries();
    }

    public boolean equals(Object obj) {
        return this.builder.equals(obj);
    }

    public int hashCode() {
        return this.builder.hashCode();
    }

    public String toString() {
        return this.builder.toString();
    }

    public void resolveResources(AddonInfoBuilder addonInfo) {
        AddonId addon = addonInfo.getAddon();
        Response resources = this.resolver.resolveResources(addon);
        for (File resource : (File[])resources.get()) {
            addonInfo.addResource(resource);
        }
    }
}

