/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.localstore;

import java.io.File;
import java.net.URI;
import org.jboss.forge.roaster._shade.org.eclipse.core.filesystem.EFS;
import org.jboss.forge.roaster._shade.org.eclipse.core.filesystem.IFileStore;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.utils.FileUtil;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IPathVariableManager;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IResource;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IWorkspaceRoot;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.ResourcesPlugin;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Assert;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Path;

public class FileStoreRoot {
    private int chop;
    private boolean isValid = true;
    private IPath localRoot;
    private IPath canonicalLocalRoot;
    private URI root;
    private URI canonicalRoot;

    FileStoreRoot(URI rootURI, IPath workspacePath) {
        Assert.isNotNull(rootURI);
        Assert.isNotNull(workspacePath);
        this.root = rootURI;
        this.chop = workspacePath.segmentCount();
        this.localRoot = this.toLocalPath(this.root);
    }

    private IPathVariableManager getManager(IPath workspacePath) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = workspaceRoot.findMember(workspacePath);
        if (resource != null) {
            return resource.getPathVariableManager();
        }
        if (workspacePath.segmentCount() == 0) {
            return workspaceRoot.getPathVariableManager();
        }
        if (workspacePath.segmentCount() == 1) {
            return workspaceRoot.getProject(workspacePath.lastSegment()).getPathVariableManager();
        }
        return workspaceRoot.getFile(workspacePath).getPathVariableManager();
    }

    public URI computeURI(IPath workspacePath) {
        return this.computeURI(workspacePath, false);
    }

    public URI computeURI(IPath workspacePath, boolean canonical) {
        IPath childPath = workspacePath.removeFirstSegments(this.chop);
        URI rootURI = canonical ? this.getCanonicalRoot() : this.root;
        rootURI = this.getManager(workspacePath).resolveURI(rootURI);
        if (childPath.segmentCount() == 0) {
            return rootURI;
        }
        try {
            return EFS.getStore((URI)rootURI).getFileStore(childPath).toURI();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    IFileStore createStore(IPath workspacePath, IResource resource) throws CoreException {
        IPath childPath = workspacePath.removeFirstSegments(this.chop);
        URI uri = resource.getPathVariableManager().resolveURI(resource.isLinked() ? this.root : this.getCanonicalRoot());
        if (!uri.isAbsolute()) {
            return EFS.getNullFileSystem().getStore(workspacePath);
        }
        IFileStore rootStore = EFS.getStore((URI)uri);
        if (childPath.segmentCount() == 0) {
            return rootStore;
        }
        return rootStore.getFileStore(childPath);
    }

    boolean isValid() {
        return this.isValid;
    }

    IPath localLocation(IPath workspacePath, IResource resource) {
        return this.localLocation(workspacePath, resource, false);
    }

    IPath localLocation(IPath workspacePath, IResource resource, boolean canonical) {
        if (this.localRoot == null) {
            return null;
        }
        IPath rootPath = canonical ? this.getCanonicalLocalRoot() : this.localRoot;
        IPath location = workspacePath.segmentCount() <= this.chop ? rootPath : rootPath.append(workspacePath.removeFirstSegments(this.chop));
        location = resource.getPathVariableManager().resolvePath(location);
        if (location == null || !location.isAbsolute()) {
            return null;
        }
        return location;
    }

    void setValid(boolean value) {
        this.isValid = value;
    }

    private IPath toLocalPath(URI uri) {
        try {
            File localFile = EFS.getStore((URI)uri).toLocalFile(0, null);
            return localFile == null ? null : new Path(localFile.getAbsolutePath());
        }
        catch (CoreException coreException) {
            return FileUtil.toPath(uri);
        }
    }

    private synchronized IPath getCanonicalLocalRoot() {
        if (this.canonicalLocalRoot == null && this.localRoot != null) {
            this.canonicalLocalRoot = FileUtil.canonicalPath(this.localRoot);
        }
        return this.canonicalLocalRoot;
    }

    private synchronized URI getCanonicalRoot() {
        if (this.canonicalRoot == null) {
            this.canonicalRoot = FileUtil.canonicalURI(this.root);
        }
        return this.canonicalRoot;
    }
}

