/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TagElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TextElement;
import org.jboss.forge.roaster.model.JavaDocTag;
import org.jboss.forge.roaster.model.impl.JavaDocTagImpl;
import org.jboss.forge.roaster.model.source.JavaDocSource;

public class JavaDocImpl<O>
implements JavaDocSource<O> {
    private static final String TAG_NAME_CANNOT_BE_NULL = "Tag name cannot be null";
    private final O origin;
    private final Javadoc javadoc;

    public JavaDocImpl(O origin, Javadoc javadoc) {
        Objects.requireNonNull(javadoc, "Javadoc cannot be null");
        this.origin = origin;
        this.javadoc = javadoc;
    }

    public O getOrigin() {
        return this.origin;
    }

    public Object getInternal() {
        return this.javadoc;
    }

    public String getText() {
        List tagList = this.javadoc.tags();
        StringBuilder text = new StringBuilder();
        for (TagElement tagElement : tagList) {
            if (tagElement.getTagName() != null) continue;
            for (Object fragment : tagElement.fragments()) {
                if (!(fragment instanceof TextElement)) continue;
                String textFragment = ((TextElement)fragment).getText();
                if (text.length() > 0 && text.charAt(text.length() - 1) != ' ' && !textFragment.startsWith(" ")) {
                    text.append(' ');
                }
                text.append(textFragment);
            }
        }
        return text.toString().trim();
    }

    public String getFullText() {
        List tagList = this.javadoc.tags();
        StringBuilder text = new StringBuilder();
        for (TagElement tagElement : tagList) {
            if (tagElement.getTagName() != null) {
                text.append(tagElement.getTagName());
            }
            List fragments = tagElement.fragments();
            Iterator iterator = fragments.iterator();
            while (iterator.hasNext()) {
                Object fragment = iterator.next();
                if (fragment instanceof SimpleName) {
                    text.append(' ').append(fragment);
                    continue;
                }
                text.append(fragment);
                if (!iterator.hasNext()) continue;
                text.append(' ');
            }
            text.append(System.getProperty("line.separator"));
        }
        return text.toString().trim();
    }

    public Set<String> getTagNames() {
        LinkedHashSet<String> tagNames = new LinkedHashSet<String>();
        List tagList = this.javadoc.tags();
        for (TagElement tagElement : tagList) {
            String tagName = tagElement.getTagName();
            if (tagName == null) continue;
            tagNames.add(tagName);
        }
        return tagNames;
    }

    public List<JavaDocTag> getTags() {
        ArrayList<JavaDocTag> tags = new ArrayList<JavaDocTag>();
        List tagElements = this.javadoc.tags();
        for (TagElement tagElement : tagElements) {
            if (tagElement.getTagName() == null) continue;
            tags.add(new JavaDocTagImpl(tagElement));
        }
        return tags;
    }

    public List<JavaDocTag> getTags(String tagName) {
        Objects.requireNonNull(tagName, TAG_NAME_CANNOT_BE_NULL);
        ArrayList<JavaDocTag> tags = new ArrayList<JavaDocTag>();
        List tagElements = this.javadoc.tags();
        for (TagElement tagElement : tagElements) {
            if (!tagName.equals(tagElement.getTagName())) continue;
            tags.add(new JavaDocTagImpl(tagElement));
        }
        return tags;
    }

    public JavaDocSource<O> setFullText(String text) {
        this.javadoc.tags().clear();
        this.setText(text);
        return this;
    }

    public JavaDocSource<O> setText(String text) {
        TagElement tagElement = null;
        List tags = this.javadoc.tags();
        for (TagElement tagElementItem : tags) {
            if (tagElementItem.getTagName() != null) continue;
            tagElement = tagElementItem;
            break;
        }
        if (tagElement == null) {
            tagElement = this.javadoc.getAST().newTagElement();
            this.javadoc.tags().add(0, tagElement);
        }
        tagElement.fragments().clear();
        TextElement textElement = this.javadoc.getAST().newTextElement();
        textElement.setText(text);
        tagElement.fragments().add(textElement);
        return this;
    }

    public JavaDocSource<O> addTagValue(String tagName, String tagValue) {
        Objects.requireNonNull(tagName, TAG_NAME_CANNOT_BE_NULL);
        TagElement tagElement = this.javadoc.getAST().newTagElement();
        TextElement textElement = this.javadoc.getAST().newTextElement();
        tagElement.setTagName(tagName);
        textElement.setText(tagValue);
        tagElement.fragments().add(textElement);
        this.javadoc.tags().add(tagElement);
        return this;
    }

    public JavaDocSource<O> addTagValue(JavaDocTag tag) {
        this.addTagValue(tag.getName(), tag.getValue());
        return this;
    }

    public JavaDocSource<O> removeTags(String tagName) {
        Objects.requireNonNull(tagName, TAG_NAME_CANNOT_BE_NULL);
        List tags = this.javadoc.tags();
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            TagElement next = (TagElement)iterator.next();
            if (!tagName.equals(next.getTagName())) continue;
            iterator.remove();
        }
        return this;
    }

    public JavaDocSource<O> removeTag(JavaDocTag tag) {
        List tags = this.javadoc.tags();
        tags.remove(tag.getInternal());
        return this;
    }

    public JavaDocSource<O> removeAllTags() {
        List tags = this.javadoc.tags();
        Iterator iterator = tags.iterator();
        while (iterator.hasNext()) {
            TagElement next = (TagElement)iterator.next();
            if (next.getTagName() == null) continue;
            iterator.remove();
        }
        return this;
    }
}

