/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ConfigFeatureBranch;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;

class SpecFeatures {
    private static final byte FREE = 0;
    private static final byte PROCESSING = 1;
    final ResolvedFeatureSpec spec;
    private final List<ResolvedFeature> features = new ArrayList<ResolvedFeature>();
    private ConfigFeatureBranch branch;
    private byte state = 0;

    SpecFeatures(ResolvedFeatureSpec spec) {
        this.spec = spec;
    }

    boolean isFree() {
        return this.state == 0;
    }

    void schedule() {
        this.state = 1;
    }

    void free() {
        this.state = 0;
    }

    void setBranch(ConfigFeatureBranch branch) throws ProvisioningException {
        if (this.branch != null) {
            throw new ProvisioningException("The branch has already been set for " + this.spec.id);
        }
        this.branch = branch;
        branch.setSpecBranch();
    }

    public ConfigFeatureBranch getBranch() {
        return this.branch;
    }

    boolean isBranchSet() {
        return this.branch != null;
    }

    void add(ResolvedFeature feature) {
        this.features.add(feature);
        feature.setSpecFeatures(this);
    }

    List<ResolvedFeature> getFeatures() {
        return this.features;
    }
}

