/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.ConfigLayerXml;
import org.jboss.galleon.xml.FeatureGroupXml;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class ConfigLayerXmlParser20
implements PlugableXmlParser<ConfigLayerSpec.Builder> {
    public static final String NAMESPACE_2_0 = "urn:jboss:galleon:layer-spec:2.0";
    public static final QName ROOT_2_0 = new QName("urn:jboss:galleon:layer-spec:2.0", ConfigLayerXml.Element.LAYER_SPEC.getLocalName());

    ConfigLayerXmlParser20() {
    }

    @Override
    public QName getRoot() {
        return ROOT_2_0;
    }

    public void readElement(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        ConfigLayerXmlParser20.readConfigLayer(reader, builder);
    }

    private static void readConfigLayer(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        String name = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    builder.setName(name);
                    continue block11;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element e = Element.elementsByLocal.get(reader.getName().getLocalPart());
                    if (e != null) {
                        switch (e) {
                            case DEPENDENCIES: {
                                ConfigLayerXmlParser20.readDeps(reader, builder);
                                continue block12;
                            }
                            case PROPS: {
                                ConfigLayerXmlParser20.readProps(reader, builder);
                                continue block12;
                            }
                        }
                        throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                    }
                    if (FeatureGroupXml.handleFeatureGroupBodyElement(reader, builder)) continue block12;
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProps(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case PROP: {
                            ConfigLayerXmlParser20.readProp(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProp(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (name == null) {
            if (value == null) {
                HashSet<Attribute> attrs = new HashSet<Attribute>();
                attrs.add(Attribute.NAME);
                attrs.add(Attribute.VALUE);
                throw ParsingUtils.missingAttributes(reader.getLocation(), attrs);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        builder.setProperty(name, value);
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
    }

    private static void readDeps(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName().getLocalPart());
                    switch (element) {
                        case LAYER: {
                            ConfigLayerXmlParser20.readLayer(reader, builder);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readLayer(XMLExtendedStreamReader reader, ConfigLayerSpec.Builder builder) throws XMLStreamException {
        String name = null;
        boolean optional = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        builder.addLayerDep(name, optional);
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
    }

    protected static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        OPTIONAL("optional"),
        VALUE("value"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(3);
            attributes.put(new QName(NAME.getLocalName()), NAME);
            attributes.put(new QName(VALUE.getLocalName()), VALUE);
            attributes.put(new QName(OPTIONAL.getLocalName()), OPTIONAL);
            attributes.put(null, UNKNOWN);
        }
    }

    public static enum Element implements XmlNameProvider
    {
        DEPENDENCIES("dependencies"),
        LAYER("layer"),
        LAYER_SPEC("layer-spec"),
        PROPS("props"),
        PROP("prop"),
        UNKNOWN(null);

        private static final Map<String, Element> elementsByLocal;
        private final String name;
        private final String namespace = "urn:jboss:galleon:layer-spec:2.0";

        static Element of(String localName) {
            Element element = elementsByLocal.get(localName);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ConfigLayerXmlParser20.NAMESPACE_2_0;
        }

        static {
            elementsByLocal = new HashMap<String, Element>(6);
            elementsByLocal.put(Element.DEPENDENCIES.name, DEPENDENCIES);
            elementsByLocal.put(Element.LAYER.name, LAYER);
            elementsByLocal.put(Element.LAYER_SPEC.name, LAYER_SPEC);
            elementsByLocal.put(Element.PROPS.name, PROPS);
            elementsByLocal.put(Element.PROP.name, PROP);
            elementsByLocal.put(null, UNKNOWN);
        }
    }
}

