/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Map;
import java.util.Set;
import org.jboss.galleon.spec.CapabilitySpec;
import org.jboss.galleon.spec.FeatureAnnotation;
import org.jboss.galleon.spec.FeatureDependencySpec;
import org.jboss.galleon.spec.FeatureParameterSpec;
import org.jboss.galleon.spec.FeatureReferenceSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.xml.BaseXmlWriter;
import org.jboss.galleon.xml.FeatureSpecXmlParser10;
import org.jboss.galleon.xml.PackageXmlWriter;
import org.jboss.galleon.xml.util.ElementNode;

public class FeatureSpecXmlWriter
extends BaseXmlWriter<FeatureSpec> {
    private static final String TRUE = "true";
    private static final FeatureSpecXmlWriter INSTANCE = new FeatureSpecXmlWriter();

    public static FeatureSpecXmlWriter getInstance() {
        return INSTANCE;
    }

    private FeatureSpecXmlWriter() {
    }

    @Override
    protected ElementNode toElement(FeatureSpec featureSpec) {
        ElementNode specE = FeatureSpecXmlWriter.addElement(null, FeatureSpecXmlParser10.Element.FEATURE_SPEC);
        FeatureSpecXmlWriter.addAttribute(specE, FeatureSpecXmlParser10.Attribute.NAME, featureSpec.getName());
        if (featureSpec.hasAnnotations()) {
            for (FeatureAnnotation fa : featureSpec.getAnnotations()) {
                ElementNode annotationE = FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.ANNOTATION);
                FeatureSpecXmlWriter.addAttribute(annotationE, FeatureSpecXmlParser10.Attribute.NAME, fa.getName());
                if (!fa.hasElements()) continue;
                for (Map.Entry<String, String> entry : fa.getElements().entrySet()) {
                    ElementNode elemE = FeatureSpecXmlWriter.addElement(annotationE, FeatureSpecXmlParser10.Element.ELEM);
                    FeatureSpecXmlWriter.addAttribute(elemE, FeatureSpecXmlParser10.Attribute.NAME, entry.getKey());
                    if (entry.getValue() == null) continue;
                    FeatureSpecXmlWriter.addAttribute(elemE, FeatureSpecXmlParser10.Attribute.VALUE, entry.getValue());
                }
            }
        }
        if (featureSpec.providesCapabilities()) {
            this.writeCaps(FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.PROVIDES), featureSpec.getProvidedCapabilities());
        }
        if (featureSpec.requiresCapabilities()) {
            this.writeCaps(FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.REQUIRES), featureSpec.getRequiredCapabilities());
        }
        if (featureSpec.hasFeatureDeps()) {
            ElementNode depsE = FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.DEPENDENCIES);
            for (FeatureDependencySpec dep : featureSpec.getFeatureDeps()) {
                ElementNode depE = FeatureSpecXmlWriter.addElement(depsE, FeatureSpecXmlParser10.Element.DEPENDENCY);
                FeatureSpecXmlWriter.addAttribute(depE, FeatureSpecXmlParser10.Attribute.FEATURE_ID, dep.getFeatureId().toString());
                if (dep.getOrigin() != null) {
                    FeatureSpecXmlWriter.addAttribute(depE, FeatureSpecXmlParser10.Attribute.DEPENDENCY, dep.getOrigin());
                }
                if (!dep.isInclude()) continue;
                FeatureSpecXmlWriter.addAttribute(depE, FeatureSpecXmlParser10.Attribute.INCLUDE, TRUE);
            }
        }
        if (featureSpec.hasFeatureRefs()) {
            ElementNode refsE = FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.REFERENCES);
            for (FeatureReferenceSpec ref : featureSpec.getFeatureRefs()) {
                ElementNode refE = FeatureSpecXmlWriter.addElement(refsE, FeatureSpecXmlParser10.Element.REFERENCE);
                String feature = ref.getFeature().toString();
                if (ref.getOrigin() != null) {
                    FeatureSpecXmlWriter.addAttribute(refE, FeatureSpecXmlParser10.Attribute.DEPENDENCY, ref.getOrigin());
                }
                FeatureSpecXmlWriter.addAttribute(refE, FeatureSpecXmlParser10.Attribute.FEATURE, feature);
                if (!feature.equals(ref.getName())) {
                    FeatureSpecXmlWriter.addAttribute(refE, FeatureSpecXmlParser10.Attribute.NAME, ref.getName());
                }
                if (ref.isNillable()) {
                    FeatureSpecXmlWriter.addAttribute(refE, FeatureSpecXmlParser10.Attribute.NILLABLE, TRUE);
                }
                if (ref.isInclude()) {
                    FeatureSpecXmlWriter.addAttribute(refE, FeatureSpecXmlParser10.Attribute.INCLUDE, TRUE);
                }
                for (Map.Entry<String, String> mapping : ref.getMappedParams().entrySet()) {
                    ElementNode paramE = FeatureSpecXmlWriter.addElement(refE, FeatureSpecXmlParser10.Element.PARAMETER);
                    FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.NAME, mapping.getKey());
                    FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.MAPS_TO, mapping.getValue());
                }
            }
        }
        if (featureSpec.hasParams()) {
            ElementNode paramsE = FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.PARAMETERS);
            for (FeatureParameterSpec paramSpec : featureSpec.getParams().values()) {
                ElementNode paramE = FeatureSpecXmlWriter.addElement(paramsE, FeatureSpecXmlParser10.Element.PARAMETER);
                FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.NAME, paramSpec.getName());
                if (paramSpec.isFeatureId()) {
                    FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.FEATURE_ID, TRUE);
                } else if (paramSpec.isNillable()) {
                    FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.NILLABLE, TRUE);
                }
                if (paramSpec.hasDefaultValue()) {
                    FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.DEFAULT, paramSpec.getDefaultValue());
                }
                if (paramSpec.getType() == null || "String".equals(paramSpec.getType())) continue;
                FeatureSpecXmlWriter.addAttribute(paramE, FeatureSpecXmlParser10.Attribute.TYPE, paramSpec.getType());
            }
        }
        if (featureSpec.hasPackageDeps()) {
            PackageXmlWriter.writePackageDeps(featureSpec, FeatureSpecXmlWriter.addElement(specE, FeatureSpecXmlParser10.Element.PACKAGES));
        }
        return specE;
    }

    private void writeCaps(ElementNode parent, Set<CapabilitySpec> caps) {
        for (CapabilitySpec cap : caps) {
            ElementNode capE = FeatureSpecXmlWriter.addElement(parent, FeatureSpecXmlParser10.Element.CAPABILITY);
            FeatureSpecXmlWriter.addAttribute(capE, FeatureSpecXmlParser10.Attribute.NAME, cap.toString());
            if (!cap.isOptional()) continue;
            FeatureSpecXmlWriter.addAttribute(capE, FeatureSpecXmlParser10.Attribute.OPTIONAL, TRUE);
        }
    }
}

