/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.Errors;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageDepsSpecBuilder;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class PackageDepsSpecXmlParser {
    public static final String ORIGIN = "origin";
    public static final String PACKAGE = "package";
    private static final PackageDepsSpecXmlParser INSTANCE = new PackageDepsSpecXmlParser();

    public static PackageDepsSpecXmlParser getInstance() {
        return INSTANCE;
    }

    public static void parsePackageDeps(XmlNameProvider parent, XMLExtendedStreamReader reader, PackageDepsSpecBuilder<?> pkgDeps) throws XMLStreamException {
        ParsingUtils.parseNoAttributes((XMLStreamReader)reader);
        boolean empty = true;
        block12: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (empty) {
                        throw ParsingUtils.expectedAtLeastOneChild(reader, parent, PackageDepsSpecXmlParser.xmlNameProvider(parent.getNamespace(), PACKAGE), PackageDepsSpecXmlParser.xmlNameProvider(parent.getNamespace(), ORIGIN));
                    }
                    return;
                }
                case 1: {
                    empty = false;
                    switch (reader.getLocalName()) {
                        case "package": {
                            pkgDeps.addPackageDep(PackageDepsSpecXmlParser.parsePackageDependency(reader));
                            continue block12;
                        }
                        case "origin": {
                            PackageDepsSpecXmlParser.parseOrigin(reader, pkgDeps);
                            continue block12;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static PackageDependencySpec parsePackageDependency(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        Boolean optional = null;
        boolean passive = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block5;
                }
                case OPTIONAL: {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block5;
                }
                case PASSIVE: {
                    passive = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block5;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent((XMLStreamReader)reader);
        if (passive) {
            if (optional != null && !optional.booleanValue()) {
                throw new XMLStreamException(Errors.requiredPassiveDependency(name), reader.getLocation());
            }
            return PackageDependencySpec.passive(name);
        }
        return optional == null || optional == false ? PackageDependencySpec.required(name) : PackageDependencySpec.optional(name);
    }

    private static void parseOrigin(XMLExtendedStreamReader reader, PackageDepsSpecBuilder<?> pkgDeps) throws XMLStreamException {
        String origin = null;
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    origin = reader.getAttributeValue(i);
                    continue block13;
                }
                default: {
                    throw ParsingUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (origin == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "package": {
                            pkgDeps.addPackageDep(origin, PackageDepsSpecXmlParser.parsePackageDependency(reader));
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
                }
            }
            throw ParsingUtils.unexpectedContent((XMLStreamReader)reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static XmlNameProvider xmlNameProvider(final String ns, final String name) {
        return new XmlNameProvider(){

            @Override
            public String getNamespace() {
                return ns;
            }

            @Override
            public String getLocalName() {
                return name;
            }
        };
    }

    protected static enum Attribute implements XmlNameProvider
    {
        NAME("name"),
        OPTIONAL("optional"),
        PASSIVE("passive"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        static {
            attributes = new HashMap<QName, Attribute>(4);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.OPTIONAL.name), OPTIONAL);
            attributes.put(new QName(Attribute.PASSIVE.name), PASSIVE);
            attributes.put(null, UNKNOWN);
        }
    }
}

