/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.caller;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.CoreVersion;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.api.GalleonFeaturePackLayout;
import org.jboss.galleon.api.GalleonProvisioningLayout;
import org.jboss.galleon.api.GalleonProvisioningRuntime;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilder;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayersBuilderItf;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.caller.GalleonProvisioningLayoutImpl;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.core.builder.LocalFP;
import org.jboss.galleon.core.builder.ProvisioningContext;
import org.jboss.galleon.diff.FsDiff;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.spec.FeaturePackPlugin;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisionedStateXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.jboss.galleon.xml.XmlParsers;

public class ProvisioningContextImpl
implements ProvisioningContext {
    private ProvisioningManager provisionManager;
    private ProvisioningLayoutFactory factory;
    private final URLClassLoader loader;
    private final Path home;
    private final MessageWriter msgWriter;
    private final boolean logTime;
    private final boolean recordState;
    private final UniverseResolver universeResolver;
    private final Map<String, ProgressTracker<?>> progressTrackers;
    private final Map<FeaturePackLocation.FPID, LocalFP> locals;

    ProvisioningContextImpl(URLClassLoader loader, Path home, MessageWriter msgWriter, boolean logTime, boolean recordState, UniverseResolver universeResolver, Map<String, ProgressTracker<?>> progressTrackers, Map<FeaturePackLocation.FPID, LocalFP> locals) throws ProvisioningException {
        this.loader = loader;
        this.home = home;
        this.msgWriter = msgWriter;
        this.logTime = logTime;
        this.recordState = recordState;
        this.universeResolver = universeResolver;
        this.progressTrackers = progressTrackers;
        this.locals = locals;
    }

    public GalleonProvisioningConfig getConfig(GalleonProvisioningConfig config) throws ProvisioningException {
        return ProvisioningConfig.toConfig(ProvisioningConfig.toConfig(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provision(GalleonProvisioningConfig config, List<Path> customConfigs, Map<String, String> options) throws ProvisioningException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            this.getManager().provision(ProvisioningConfig.toConfig(config, customConfigs), options);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void provision(Path config, Map<String, String> options) throws ProvisioningException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            this.getManager().provision(config, options);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    public String getCoreVersion() {
        return CoreVersion.getVersion();
    }

    public void storeProvisioningConfig(GalleonProvisioningConfig config, Path file) throws XMLStreamException, IOException, ProvisioningException {
        try (FileWriter writer = new FileWriter(file.toFile());){
            ProvisioningXmlWriter.getInstance().write(ProvisioningConfig.toConfig(config), writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GalleonProvisioningRuntime getProvisioningRuntime(GalleonProvisioningConfig config) throws ProvisioningException {
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        try {
            ProvisioningRuntime provisioningRuntime = this.getManager().getRuntime(ProvisioningConfig.toConfig(config));
            return provisioningRuntime;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalLoader);
        }
    }

    public UniverseResolver getUniverseResolver() {
        return this.universeResolver;
    }

    public void close() {
        if (this.provisionManager != null) {
            this.provisionManager.close();
        }
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public GalleonProvisioningConfig parseProvisioningFile(Path provisioning) throws ProvisioningException {
        ProvisioningConfig c = ProvisioningXmlParser.parse(provisioning);
        if (c == null) {
            return null;
        }
        return ProvisioningConfig.toConfig(c);
    }

    public List<GalleonFeaturePackLayout> getOrderedFeaturePackLayouts(GalleonProvisioningConfig config) throws ProvisioningException {
        ArrayList<GalleonFeaturePackLayout> lst = new ArrayList<GalleonFeaturePackLayout>();
        try (ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(ProvisioningConfig.toConfig(config));){
            lst.addAll(layout.getOrderedFeaturePacks());
            ArrayList<GalleonFeaturePackLayout> arrayList = lst;
            return arrayList;
        }
    }

    public Set<String> getOrderedFeaturePackPluginLocations(GalleonProvisioningConfig config) throws ProvisioningException {
        HashSet<String> lst = new HashSet<String>();
        try (ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(ProvisioningConfig.toConfig(config));){
            for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                for (FeaturePackPlugin plugin : fp.getSpec().getPlugins().values()) {
                    lst.add(plugin.getLocation());
                }
            }
        }
        return lst;
    }

    public GalleonConfigurationWithLayersBuilderItf buildConfigurationBuilder(GalleonConfigurationWithLayers config) {
        if (config instanceof ConfigModel) {
            ConfigModel pconfig = (ConfigModel)config;
            return ConfigModel.builder(pconfig);
        }
        return GalleonConfigurationWithLayersBuilder.builder((GalleonConfigurationWithLayers)config);
    }

    public List<String> getInstalledPacks(Path dir) throws ProvisioningException {
        Collection<ProvisionedFeaturePack> featurePacks = ProvisionedStateXmlParser.parse(PathsUtils.getProvisionedStateXml((Path)dir)).getFeaturePacks();
        return featurePacks.stream().map(fp -> fp.getFPID().getProducer().getName()).collect(Collectors.toList());
    }

    public GalleonProvisioningConfig loadProvisioningConfig(InputStream is) throws ProvisioningException, XMLStreamException {
        InputStreamReader reader = new InputStreamReader(is);
        ProvisioningConfig.Builder builder = ProvisioningConfig.builder();
        XmlParsers.parse(reader, builder);
        return ProvisioningConfig.toConfig(builder.build());
    }

    public FsDiff getFsDiff() throws ProvisioningException {
        return this.getManager().getFsDiff();
    }

    public void install(FeaturePackLocation loc) throws ProvisioningException {
        this.getManager().install(loc);
    }

    public void install(GalleonFeaturePackConfig config) throws ProvisioningException {
        this.getManager().install(ProvisioningConfig.toFeaturePackConfig(config));
    }

    public void uninstall(FeaturePackLocation.FPID loc) throws ProvisioningException {
        this.getManager().uninstall(loc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasOrderedFeaturePacksConfig(GalleonProvisioningConfig config, ConfigId cfg) throws ProvisioningException {
        try (ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(ProvisioningConfig.toConfig(config));){
            for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                try {
                    LayoutUtils.getConfigXml(fp.getDir(), cfg, true);
                    boolean bl = true;
                    return bl;
                }
                catch (ProvisioningDescriptionException provisioningDescriptionException) {
                    try {
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return false;
                    }
                }
            }
        }
    }

    public GalleonProvisioningLayout newProvisioningLayout(GalleonProvisioningConfig config) throws ProvisioningException {
        ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(ProvisioningConfig.toConfig(config));
        return new GalleonProvisioningLayoutImpl(layout);
    }

    public GalleonProvisioningLayout newProvisioningLayout(Path file, boolean install) throws ProvisioningException {
        ProvisioningLayout<FeaturePackLayout> layout = this.getLayoutFactory().newConfigLayout(file, install);
        return new GalleonProvisioningLayoutImpl(layout);
    }

    private ProvisioningManager getManager() throws ProvisioningException {
        if (this.provisionManager == null) {
            ProvisioningManager.Builder builder = ProvisioningManager.builder().setInstallationHome(this.home).setMessageWriter(this.msgWriter).setLogTime(this.logTime).setRecordState(this.recordState);
            if (this.universeResolver != null) {
                builder.setUniverseResolver(this.universeResolver);
            }
            this.provisionManager = builder.build();
            for (Map.Entry<String, ProgressTracker<?>> entry : this.progressTrackers.entrySet()) {
                this.provisionManager.getLayoutFactory().setProgressTracker(entry.getKey(), entry.getValue());
            }
            for (LocalFP fp : this.locals.values()) {
                this.provisionManager.getLayoutFactory().addLocal(fp.getPath(), fp.isInstallInUniverse());
            }
        }
        return this.provisionManager;
    }

    private ProvisioningLayoutFactory getLayoutFactory() throws ProvisioningException {
        if (this.factory == null) {
            this.factory = ProvisioningLayoutFactory.getInstance();
            for (LocalFP fp : this.locals.values()) {
                this.factory.addLocal(fp.getPath(), fp.isInstallInUniverse());
            }
        }
        return this.factory;
    }
}

