/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainerBuilder;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupSupport;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.PackageDepsSpecBuilder;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.util.CollectionUtils;

public abstract class FeatureGroupBuilderSupport<B extends FeatureGroupBuilderSupport<B>>
extends PackageDepsSpecBuilder<B>
implements ConfigItemContainerBuilder<B> {
    protected String origin;
    protected String name;
    protected boolean inheritFeatures = true;
    protected Set<SpecId> includedSpecs = Collections.emptySet();
    protected Map<FeatureId, FeatureConfig> includedFeatures = Collections.emptyMap();
    protected Set<SpecId> excludedSpecs = Collections.emptySet();
    protected Map<FeatureId, String> excludedFeatures = Collections.emptyMap();
    protected Map<String, FeatureGroup.Builder> externalFgConfigs = Collections.emptyMap();
    protected List<ConfigItem> items = Collections.emptyList();

    protected FeatureGroupBuilderSupport() {
    }

    protected FeatureGroupBuilderSupport(String name) {
        this.name = name;
    }

    protected FeatureGroupBuilderSupport(FeatureGroupSupport fg) {
        super(fg);
        this.name = fg.name;
        this.origin = fg.origin;
        this.inheritFeatures = fg.inheritFeatures;
        this.includedSpecs = CollectionUtils.clone(fg.includedSpecs);
        this.includedFeatures = CollectionUtils.clone(fg.includedFeatures);
        this.excludedSpecs = CollectionUtils.clone(fg.excludedSpecs);
        this.excludedFeatures = CollectionUtils.clone(fg.excludedFeatures);
        if (!fg.externalFgConfigs.isEmpty()) {
            for (Map.Entry<String, FeatureGroup> entry : fg.externalFgConfigs.entrySet()) {
                this.externalFgConfigs = CollectionUtils.putLinked(this.externalFgConfigs, (Object)entry.getKey(), (Object)FeatureGroup.builder(entry.getValue()));
            }
        }
        this.items = CollectionUtils.clone(fg.items);
    }

    public B setOrigin(String origin) {
        this.origin = origin;
        return (B)this;
    }

    public B setName(String name) {
        this.name = name;
        return (B)this;
    }

    public String getName() {
        return this.name;
    }

    public B setInheritFeatures(boolean inheritFeatures) {
        this.inheritFeatures = inheritFeatures;
        return (B)this;
    }

    public B includeSpec(String origin, String spec) throws ProvisioningDescriptionException {
        if (origin == null) {
            return this.includeSpec(spec);
        }
        this.getExternalFgConfig(origin).includeSpec(spec);
        return (B)this;
    }

    public B includeSpec(String spec) throws ProvisioningDescriptionException {
        SpecId specId = SpecId.fromString(spec);
        if (this.excludedSpecs.contains(specId)) {
            throw new ProvisioningDescriptionException(specId + " spec has been explicitly excluded");
        }
        this.includedSpecs = CollectionUtils.addLinked(this.includedSpecs, (Object)specId);
        return (B)this;
    }

    public B includeFeature(FeatureId featureId) throws ProvisioningDescriptionException {
        return this.includeFeature(featureId, null);
    }

    public B includeFeature(String origin, FeatureId featureId) throws ProvisioningDescriptionException {
        return this.includeFeature(origin, featureId, null);
    }

    private B includeFeature(String origin, FeatureId featureId, FeatureConfig feature) throws ProvisioningDescriptionException {
        if (origin == null) {
            return this.includeFeature(featureId, feature);
        }
        this.getExternalFgConfig(origin).includeFeature(featureId, feature);
        return (B)this;
    }

    public B includeFeature(FeatureId featureId, FeatureConfig feature) throws ProvisioningDescriptionException {
        if (feature != null && feature.getOrigin() != null) {
            String origin = feature.getOrigin();
            feature.setOrigin(null);
            this.getExternalFgConfig(origin).includeFeature(featureId, feature);
            return (B)this;
        }
        if (this.excludedFeatures.containsKey(featureId)) {
            throw new ProvisioningDescriptionException(featureId + " has been explicitly excluded");
        }
        if (feature == null) {
            feature = new FeatureConfig(featureId.getSpec());
        } else if (feature.specId == null) {
            feature.specId = featureId.getSpec();
        }
        for (Map.Entry<String, String> idEntry : featureId.getParams().entrySet()) {
            String prevValue = feature.putParam(idEntry.getKey(), idEntry.getValue());
            if (prevValue == null || prevValue.equals(idEntry.getValue())) continue;
            throw new ProvisioningDescriptionException("Parameter " + idEntry.getKey() + " has value '" + idEntry.getValue() + "' in feature ID and value '" + prevValue + "' in the feature body");
        }
        this.includedFeatures = CollectionUtils.putLinked(this.includedFeatures, (Object)featureId, (Object)feature);
        return (B)this;
    }

    public B excludeSpec(String origin, String spec) throws ProvisioningDescriptionException {
        if (origin == null) {
            return this.excludeSpec(spec);
        }
        this.getExternalFgConfig(origin).excludeSpec(spec);
        return (B)this;
    }

    public B excludeSpec(String spec) throws ProvisioningDescriptionException {
        SpecId specId = SpecId.fromString(spec);
        if (this.includedSpecs.contains(specId)) {
            throw new ProvisioningDescriptionException(specId + " spec has been inplicitly excluded");
        }
        this.excludedSpecs = CollectionUtils.add(this.excludedSpecs, (Object)specId);
        return (B)this;
    }

    public B excludeFeature(String origin, FeatureId featureId) throws ProvisioningDescriptionException {
        return this.excludeFeature(origin, featureId, null);
    }

    public B excludeFeature(String origin, FeatureId featureId, String parentRef) throws ProvisioningDescriptionException {
        if (origin == null) {
            return this.excludeFeature(featureId, parentRef);
        }
        this.getExternalFgConfig(origin).excludeFeature(featureId, parentRef);
        return (B)this;
    }

    public B excludeFeature(FeatureId featureId) throws ProvisioningDescriptionException {
        return this.excludeFeature(featureId, null);
    }

    public B excludeFeature(FeatureId featureId, String parentRef) throws ProvisioningDescriptionException {
        if (this.includedFeatures.containsKey(featureId)) {
            throw new ProvisioningDescriptionException(featureId + " has been explicitly included");
        }
        this.excludedFeatures = CollectionUtils.put(this.excludedFeatures, (Object)featureId, (Object)parentRef);
        return (B)this;
    }

    public B removeExcludedFeature(FeatureId featureId) throws ProvisioningDescriptionException {
        this.excludedFeatures = CollectionUtils.remove(this.excludedFeatures, (Object)featureId);
        return (B)this;
    }

    @Override
    public B addConfigItem(ConfigItem item) {
        this.items = CollectionUtils.add(this.items, (Object)item);
        return (B)this;
    }

    public B removeFeature(FeatureId id) throws ProvisioningDescriptionException {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            FeatureConfig conf;
            ConfigItem ci = this.items.get(i);
            if (!(ci instanceof FeatureConfig) || !(conf = (FeatureConfig)ci).getSpecId().equals(id.getSpec())) continue;
            boolean eq = true;
            for (Map.Entry<String, String> entry : id.getParams().entrySet()) {
                String val = conf.getParam(entry.getKey());
                if (val != null && val.equals(entry.getValue())) continue;
                eq = false;
                break;
            }
            if (!eq) continue;
            index = i;
            break;
        }
        if (index == -1) {
            throw new ProvisioningDescriptionException("Feature " + id + " is not added");
        }
        this.items = CollectionUtils.remove(this.items, (int)index);
        return (B)this;
    }

    private FeatureGroup.Builder getExternalFgConfig(String origin) {
        FeatureGroup.Builder fgBuilder = this.externalFgConfigs.get(origin);
        if (fgBuilder != null) {
            return fgBuilder;
        }
        fgBuilder = FeatureGroup.builder(this.inheritFeatures);
        this.externalFgConfigs = CollectionUtils.putLinked(this.externalFgConfigs, (Object)origin, (Object)fgBuilder);
        return fgBuilder;
    }
}

