/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.api.config.GalleonConfigurationWithLayers;
import org.jboss.galleon.api.config.GalleonFeaturePackConfig;
import org.jboss.galleon.api.config.GalleonProvisioningConfig;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;
import org.jboss.galleon.xml.ConfigXmlParser;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Map<String, String> options;

    public static Builder builder() {
        return new Builder();
    }

    public static ProvisioningConfig toConfig(GalleonProvisioningConfig gConfig) throws ProvisioningException, ProvisioningDescriptionException {
        return ProvisioningConfig.toConfig(gConfig, Collections.emptyList());
    }

    public static ProvisioningConfig toConfig(GalleonProvisioningConfig gConfig, List<Path> customConfigs) throws ProvisioningException, ProvisioningDescriptionException {
        Builder builder = ProvisioningConfig.builder();
        builder.addOptions(gConfig.getOptions());
        for (ConfigId configId : gConfig.getExcludedConfigs()) {
            builder.excludeDefaultConfig(configId);
        }
        for (GalleonFeaturePackConfig galleonFeaturePackConfig : gConfig.getFeaturePackDeps()) {
            builder.addFeaturePackDep(ProvisioningConfig.toFeaturePackConfig(galleonFeaturePackConfig));
        }
        for (GalleonFeaturePackConfig galleonFeaturePackConfig : gConfig.getTransitiveDeps()) {
            builder.addFeaturePackDep(ProvisioningConfig.toFeaturePackConfig(galleonFeaturePackConfig));
        }
        for (Map.Entry entry : gConfig.getUniverseNamedSpecs().entrySet()) {
            builder.addUniverse((String)entry.getKey(), (UniverseSpec)entry.getValue());
        }
        if (gConfig.getInheritConfigs() != null) {
            builder.setInheritConfigs(gConfig.getInheritConfigs());
        }
        builder.setDefaultUniverse(gConfig.getDefaultUniverse());
        builder.setInheritModelOnlyConfigs(gConfig.isInheritModelOnlyConfigs());
        for (ConfigId configId : gConfig.getExcludedConfigs()) {
            builder.excludeDefaultConfig(configId);
        }
        for (Map.Entry entry : gConfig.getFullModelsExcluded().entrySet()) {
            builder.excludeConfigModel((String)entry.getKey(), (Boolean)entry.getValue());
        }
        for (String string : gConfig.getFullModelsIncluded()) {
            builder.includeConfigModel(string);
        }
        for (ConfigId configId : gConfig.getIncludedConfigs()) {
            builder.includeDefaultConfig(configId);
        }
        for (GalleonConfigurationWithLayers galleonConfigurationWithLayers : gConfig.getDefinedConfigs()) {
            if (galleonConfigurationWithLayers instanceof ConfigModel) {
                builder.addConfig((ConfigModel)galleonConfigurationWithLayers);
                continue;
            }
            ConfigModel.Builder cBuilder = ConfigModel.builder(galleonConfigurationWithLayers.getModel(), galleonConfigurationWithLayers.getName());
            for (String string : galleonConfigurationWithLayers.getIncludedLayers()) {
                cBuilder.includeLayer(string);
            }
            for (String string : galleonConfigurationWithLayers.getExcludedLayers()) {
                cBuilder.excludeLayer(string);
            }
            for (Map.Entry entry : galleonConfigurationWithLayers.getProperties().entrySet()) {
                cBuilder.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            builder.addConfig(cBuilder.build());
        }
        for (Path path : customConfigs) {
            builder.addConfig(ProvisioningConfig.parseConfigurationFile(path));
        }
        return builder.build();
    }

    public static FeaturePackConfig toFeaturePackConfig(GalleonFeaturePackConfig dep) throws ProvisioningDescriptionException {
        FeaturePackConfig.Builder fpBuilder = dep.isTransitive() ? FeaturePackConfig.transitiveBuilder(dep.getLocation()) : FeaturePackConfig.builder(dep.getLocation());
        for (ConfigId configId : dep.getExcludedConfigs()) {
            fpBuilder.excludeDefaultConfig(configId);
        }
        fpBuilder.excludeAllPackages(dep.getExcludedPackages());
        for (Map.Entry entry : dep.getFullModelsExcluded().entrySet()) {
            fpBuilder.excludeConfigModel((String)entry.getKey(), (Boolean)entry.getValue());
        }
        for (String string : dep.getFullModelsIncluded()) {
            fpBuilder.includeConfigModel(string);
        }
        for (ConfigId configId : dep.getIncludedConfigs()) {
            fpBuilder.includeDefaultConfig(configId);
        }
        fpBuilder.includeAllPackages(dep.getIncludedPackages());
        if (dep.getInheritConfigs() != null) {
            fpBuilder.setInheritConfigs(dep.getInheritConfigs());
        }
        if (dep.getInheritPackages() != null) {
            fpBuilder.setInheritPackages(dep.getInheritPackages());
        }
        for (FeaturePackLocation.FPID fPID : dep.getPatches()) {
            fpBuilder.addPatch(fPID);
        }
        return fpBuilder.build();
    }

    private static GalleonFeaturePackConfig toFeaturePackConfig(FeaturePackConfig dep) throws ProvisioningDescriptionException {
        GalleonFeaturePackConfig.Builder fpBuilder = dep.isTransitive() ? GalleonFeaturePackConfig.transitiveBuilder((FeaturePackLocation)dep.getLocation()) : GalleonFeaturePackConfig.builder((FeaturePackLocation)dep.getLocation());
        for (ConfigId configId : dep.getExcludedConfigs()) {
            fpBuilder.excludeDefaultConfig(configId);
        }
        fpBuilder.excludeAllPackages(dep.getExcludedPackages());
        for (Map.Entry entry : dep.getFullModelsExcluded().entrySet()) {
            fpBuilder.excludeConfigModel((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (String string : dep.getFullModelsIncluded()) {
            fpBuilder.includeConfigModel(string);
        }
        for (ConfigId configId : dep.getIncludedConfigs()) {
            fpBuilder.includeDefaultConfig(configId);
        }
        fpBuilder.includeAllPackages(dep.getIncludedPackages());
        if (dep.getInheritConfigs() != null) {
            fpBuilder.setInheritConfigs(dep.getInheritConfigs().booleanValue());
        }
        if (dep.getInheritPackages() != null) {
            fpBuilder.setInheritPackages(dep.getInheritPackages().booleanValue());
        }
        for (FeaturePackLocation.FPID fPID : dep.getPatches()) {
            fpBuilder.addPatch(fPID);
        }
        return fpBuilder.build();
    }

    private static ConfigModel parseConfigurationFile(Path configuration) throws ProvisioningException {
        ConfigModel configModel;
        block8: {
            BufferedReader reader = Files.newBufferedReader(configuration);
            try {
                configModel = ConfigXmlParser.getInstance().parse(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | XMLStreamException ex) {
                    throw new ProvisioningException("Couldn't load the customization configuration " + configuration, (Throwable)ex);
                }
            }
            reader.close();
        }
        return configModel;
    }

    public static GalleonProvisioningConfig toConfig(ProvisioningConfig gConfig) throws ProvisioningDescriptionException {
        GalleonProvisioningConfig.Builder builder = GalleonProvisioningConfig.builder();
        builder.addOptions(gConfig.getOptions());
        for (ConfigId configId : gConfig.getExcludedConfigs()) {
            builder.excludeDefaultConfig(configId);
        }
        for (FeaturePackConfig featurePackConfig : gConfig.getFeaturePackDeps()) {
            builder.addFeaturePackDep(ProvisioningConfig.toFeaturePackConfig(featurePackConfig));
        }
        for (FeaturePackConfig featurePackConfig : gConfig.getTransitiveDeps()) {
            builder.addFeaturePackDep(ProvisioningConfig.toFeaturePackConfig(featurePackConfig));
        }
        for (Map.Entry entry : gConfig.getUniverseNamedSpecs().entrySet()) {
            builder.addUniverse((String)entry.getKey(), (UniverseSpec)entry.getValue());
        }
        if (gConfig.getInheritConfigs() != null) {
            builder.setInheritConfigs(gConfig.getInheritConfigs().booleanValue());
        }
        builder.setDefaultUniverse(gConfig.getDefaultUniverse());
        builder.setInheritModelOnlyConfigs(gConfig.isInheritModelOnlyConfigs());
        for (ConfigId configId : gConfig.getExcludedConfigs()) {
            builder.excludeDefaultConfig(configId);
        }
        for (Map.Entry entry : gConfig.getFullModelsExcluded().entrySet()) {
            builder.excludeConfigModel((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (String string : gConfig.getFullModelsIncluded()) {
            builder.includeConfigModel(string);
        }
        for (ConfigId configId : gConfig.getIncludedConfigs()) {
            builder.includeDefaultConfig(configId);
        }
        for (ConfigModel configModel : gConfig.getDefinedConfigs()) {
            builder.addConfig((GalleonConfigurationWithLayers)configModel);
        }
        return builder.build();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.options = CollectionUtils.unmodifiable(builder.options);
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean hasOption(String name) {
        return this.options.containsKey(name);
    }

    public String getOption(String name) {
        return this.options.get(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningConfig other = (ProvisioningConfig)obj;
        return !(this.options == null ? other.options != null : !this.options.equals(other.options));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        this.append(buf);
        if (!this.options.isEmpty()) {
            buf.append("options=");
            StringUtils.append((StringBuilder)buf, this.options.entrySet());
        }
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Map<String, String> options = Collections.emptyMap();

        private Builder() {
        }

        private Builder(ProvisioningConfig original) throws ProvisioningDescriptionException {
            if (original == null) {
                return;
            }
            if (original.hasOptions()) {
                this.addOptions(original.getOptions());
            }
            for (FeaturePackConfig fp : original.getFeaturePackDeps()) {
                this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
            }
            if (original.hasTransitiveDeps()) {
                for (FeaturePackConfig fp : original.getTransitiveDeps()) {
                    this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
                }
            }
            this.initUniverses(original);
            this.initConfigs(original);
        }

        public Builder addOption(String name, String value) {
            this.options = CollectionUtils.put(this.options, (Object)name, (Object)value);
            return this;
        }

        public Builder removeOption(String name) {
            this.options = CollectionUtils.remove(this.options, (Object)name);
            return this;
        }

        public Builder clearOptions() {
            this.options = Collections.emptyMap();
            return this;
        }

        public Builder addOptions(Map<String, String> options) {
            this.options = CollectionUtils.putAll(this.options, options);
            return this;
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

