/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.creator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.creator.FeaturePackBuilder;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseFeaturePackInstaller;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseResolverBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.ZipUtils;

public class FeaturePackCreator
extends UniverseResolverBuilder<FeaturePackCreator> {
    private static final String BUILD = "build";
    private static final String GLN_FP_INSTALLER = "gln-fp-installer";
    private Map<String, UniverseFeaturePackInstaller> ufpInstallers;
    private List<FeaturePackBuilder> fps = Collections.emptyList();
    private Path workDir;
    private Path buildDir;
    private UniverseResolver universeResolver;
    private boolean universeResolution = true;

    public static FeaturePackCreator getInstance() {
        return new FeaturePackCreator();
    }

    public FeaturePackBuilder newFeaturePack() {
        FeaturePackBuilder fp = new FeaturePackBuilder(this);
        this.addFeaturePack(fp);
        return fp;
    }

    public FeaturePackBuilder newFeaturePack(FeaturePackLocation.FPID fpid) {
        FeaturePackBuilder fp = new FeaturePackBuilder(this);
        if (fpid != null) {
            fp.setFPID(fpid);
        }
        this.addFeaturePack(fp);
        return fp;
    }

    public FeaturePackCreator addFeaturePack(FeaturePackBuilder fp) {
        this.fps = CollectionUtils.add(this.fps, (Object)fp);
        return this;
    }

    public void install() throws ProvisioningException {
        this.ufpInstallers = UniverseFeaturePackInstaller.load();
        this.universeResolver = this.buildUniverseResolver();
        try {
            for (FeaturePackBuilder fp : this.fps) {
                fp.build();
            }
        }
        finally {
            if (this.workDir != null) {
                IoUtils.recursiveDelete((Path)this.workDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(Path dir) throws ProvisioningException {
        try {
            this.universeResolution = false;
            this.buildDir = dir;
            for (FeaturePackBuilder fp : this.fps) {
                fp.build();
            }
        }
        finally {
            this.buildDir = null;
            this.universeResolution = true;
            if (this.workDir != null) {
                IoUtils.recursiveDelete((Path)this.workDir);
            }
        }
    }

    void install(FeaturePackLocation.FPID fpid, Path fpContentDir) throws ProvisioningException {
        Universe universe = null;
        UniverseFeaturePackInstaller ufpInstaller = null;
        if (this.universeResolution && (ufpInstaller = this.ufpInstallers.get((universe = this.universeResolver.getUniverse(fpid.getLocation().getUniverse())).getFactoryId())) == null) {
            throw new ProvisioningException(Errors.featurePackInstallerNotFound(universe.getFactoryId(), this.ufpInstallers.keySet()));
        }
        Path fpZip = this.getBuildDir().resolve(LayoutUtils.ensureValidFileName(fpid.toString()));
        try {
            ZipUtils.zip((Path)fpContentDir, (Path)fpZip);
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to create feature-pack archive", (Throwable)e);
        }
        if (ufpInstaller != null) {
            ufpInstaller.install(universe, fpid, fpZip);
        }
    }

    Path getWorkDir() throws ProvisioningException {
        if (this.workDir == null) {
            try {
                this.workDir = Files.createTempDirectory(GLN_FP_INSTALLER, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to create a tmp dir");
            }
        }
        return this.workDir;
    }

    private Path getBuildDir() throws ProvisioningException {
        if (this.buildDir != null) {
            return this.buildDir;
        }
        try {
            return Files.createDirectories(this.getWorkDir().resolve(BUILD), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(BaseErrors.mkdirs((Path)this.getWorkDir().resolve(BUILD)));
        }
    }
}

