/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.creator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.creator.FeaturePackBuilder;
import org.jboss.galleon.creator.tasks.FsTaskContext;
import org.jboss.galleon.creator.tasks.FsTaskList;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.xml.PackageXmlWriter;

public class PackageBuilder {
    private final FeaturePackBuilder fp;
    private boolean isDefault;
    private final PackageSpec.Builder pkg;
    private FsTaskList tasks;

    public static PackageBuilder newInstance(FeaturePackBuilder fp, String name) {
        return new PackageBuilder(fp, name);
    }

    private PackageBuilder(FeaturePackBuilder fp, String name) {
        this.fp = fp;
        this.pkg = PackageSpec.builder(name);
    }

    private FsTaskList getTasks() {
        return this.tasks == null ? (this.tasks = FsTaskList.newList()) : this.tasks;
    }

    public FeaturePackBuilder getFeaturePack() {
        return this.fp;
    }

    public PackageBuilder setStability(String stability) {
        this.pkg.setStability(stability);
        return this;
    }

    public PackageBuilder setDefault() {
        this.isDefault = true;
        return this;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public PackageBuilder addDependency(String pkgName) {
        return this.addDependency(pkgName, false);
    }

    public PackageBuilder addDependency(String pkgName, boolean optional) {
        this.pkg.addPackageDep(pkgName, optional);
        return this;
    }

    public PackageBuilder addDependency(PackageDependencySpec dep) {
        this.pkg.addPackageDep(dep);
        return this;
    }

    public PackageBuilder addDependency(String fpDepName, PackageDependencySpec dep) {
        this.pkg.addPackageDep(fpDepName, dep);
        return this;
    }

    public PackageBuilder addDependency(String fpDepName, String pkgName) {
        this.pkg.addPackageDep(fpDepName, pkgName);
        return this;
    }

    public PackageBuilder addDependency(String fpDepName, String pkgName, boolean optional) {
        this.pkg.addPackageDep(fpDepName, pkgName, optional);
        return this;
    }

    public PackageBuilder addPath(String relativeTarget, Path src) {
        return this.addPath(relativeTarget, src, true);
    }

    public PackageBuilder addPath(String relativeTarget, Path src, boolean isContent) {
        this.getTasks().copy(src, relativeTarget, isContent);
        return this;
    }

    public PackageBuilder addDir(String relativeTarget, Path src, boolean contentOnly) {
        return this.addDir(relativeTarget, src, contentOnly, true);
    }

    public PackageBuilder addDir(String relativeTarget, Path src, boolean contentOnly, boolean isContent) {
        this.getTasks().copyDir(src, relativeTarget, contentOnly, isContent);
        return this;
    }

    public PackageBuilder writeContent(String relativeTarget, String content) {
        return this.writeContent(relativeTarget, content, true);
    }

    public PackageBuilder writeContent(String relativeTarget, String content, boolean isContent) {
        this.getTasks().write(content, relativeTarget, isContent);
        return this;
    }

    public PackageSpec build(Path fpDir) {
        Path pkgDir;
        PackageSpec pkgSpec = this.pkg.build();
        try {
            pkgDir = LayoutUtils.getPackageDir(fpDir, pkgSpec.getName(), false);
        }
        catch (ProvisioningDescriptionException e) {
            throw new IllegalStateException(e);
        }
        try {
            Files.createDirectories(pkgDir, new FileAttribute[0]);
            if (this.tasks != null && !this.tasks.isEmpty()) {
                this.tasks.execute(FsTaskContext.builder().setTargetRoot(pkgDir).build());
            }
            PackageXmlWriter.getInstance().write(pkgSpec, pkgDir.resolve("package.xml"));
        }
        catch (IOException | XMLStreamException e) {
            throw new IllegalStateException(e);
        }
        return pkgSpec;
    }
}

