/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackDescription;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ConfigLayerSpecXmlParser;
import org.jboss.galleon.xml.FeaturePackXmlParser;
import org.jboss.galleon.xml.FeatureSpecXmlParser;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class FeaturePackDescriber {
    /*
     * Enabled aggressive exception aggregation
     */
    public static FeaturePackSpec readSpec(Path artifactZip) throws ProvisioningException {
        block18: {
            try (FileSystem zipfs = ZipUtils.newFileSystem((Path)artifactZip);){
                FeaturePackSpec featurePackSpec;
                block19: {
                    Iterator<Path> iterator = zipfs.getRootDirectories().iterator();
                    if (!iterator.hasNext()) break block18;
                    Path zipRoot = iterator.next();
                    Path p = zipRoot.resolve("feature-pack.xml");
                    if (!Files.exists(p, new LinkOption[0])) {
                        throw new ProvisioningException("Feature-pack archive does not contain feature-pack.xml");
                    }
                    BufferedReader reader = Files.newBufferedReader(p);
                    try {
                        featurePackSpec = FeaturePackXmlParser.getInstance().parse(reader);
                        if (reader == null) break block19;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (XMLStreamException e) {
                            throw new ProvisioningException(Errors.parseXml(p), (Throwable)e);
                        }
                    }
                    reader.close();
                }
                return featurePackSpec;
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(artifactZip), (Throwable)e);
            }
        }
        return null;
    }

    public static FeaturePackDescription describeFeaturePackZip(Path artifactZip) throws IOException, ProvisioningDescriptionException {
        try (FileSystem zipfs = ZipUtils.newFileSystem((Path)artifactZip);){
            Iterator<Path> iterator = zipfs.getRootDirectories().iterator();
            if (iterator.hasNext()) {
                Path zipRoot = iterator.next();
                FeaturePackDescription featurePackDescription = FeaturePackDescriber.describeFeaturePack(zipRoot, "UTF-8");
                return featurePackDescription;
            }
        }
        return null;
    }

    public static FeaturePackDescription describeFeaturePack(Path fpDir, String encoding) throws ProvisioningDescriptionException {
        Path configsDir;
        Path featuresDir;
        Path layersDir;
        FeaturePackDescription.Builder layoutBuilder;
        FeaturePackDescriber.assertDirectory(fpDir);
        Path fpXml = fpDir.resolve("feature-pack.xml");
        if (!Files.exists(fpXml, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(BaseErrors.pathDoesNotExist((Path)fpXml));
        }
        try (BufferedReader is = Files.newBufferedReader(fpXml, Charset.forName(encoding));){
            FeaturePackSpec.Builder specBuilder = FeaturePackSpec.builder();
            XmlParsers.parse(is, specBuilder);
            layoutBuilder = FeaturePackDescription.builder(specBuilder);
        }
        catch (IOException e) {
            throw new ProvisioningDescriptionException(Errors.openFile(fpXml));
        }
        catch (XMLStreamException e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(fpXml), (Throwable)e);
        }
        Path packagesDir = fpDir.resolve("packages");
        if (Files.exists(packagesDir, new LinkOption[0])) {
            FeaturePackDescriber.processPackages(layoutBuilder, packagesDir, encoding);
        }
        if (Files.exists(layersDir = fpDir.resolve("layers").resolve("standalone"), new LinkOption[0])) {
            FeaturePackDescriber.processLayers(layoutBuilder, layersDir, encoding);
        }
        if (Files.exists(featuresDir = fpDir.resolve("features"), new LinkOption[0])) {
            FeaturePackDescriber.processFeatures(layoutBuilder, featuresDir, encoding);
        }
        if (Files.exists(configsDir = fpDir.resolve("configs"), new LinkOption[0])) {
            FeaturePackDescriber.processConfigs(layoutBuilder, configsDir, encoding);
        }
        return layoutBuilder.build();
    }

    private static void processFeatures(FeaturePackDescription.Builder fpBuilder, Path layersDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackDescriber.assertDirectory(layersDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(layersDir);){
            for (Path path : stream) {
                fpBuilder.addFeature(FeaturePackDescriber.processFeature(path, encoding));
            }
        }
        catch (IOException e) {
            FeaturePackDescriber.failedToReadDirectory(layersDir, e);
        }
    }

    private static void processConfigs(FeaturePackDescription.Builder fpBuilder, Path configsDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackDescriber.assertDirectory(configsDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configsDir);){
            for (Path path : stream) {
                FeaturePackDescriber.processConfigModel(path, encoding, fpBuilder);
            }
        }
        catch (IOException e) {
            FeaturePackDescriber.failedToReadDirectory(configsDir, e);
        }
    }

    private static void processLayers(FeaturePackDescription.Builder fpBuilder, Path layersDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackDescriber.assertDirectory(layersDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(layersDir);){
            for (Path path : stream) {
                fpBuilder.addLayer(FeaturePackDescriber.processLayer(path, encoding));
            }
        }
        catch (IOException e) {
            FeaturePackDescriber.failedToReadDirectory(layersDir, e);
        }
    }

    private static void processPackages(FeaturePackDescription.Builder fpBuilder, Path packagesDir, String encoding) throws ProvisioningDescriptionException {
        FeaturePackDescriber.assertDirectory(packagesDir);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(packagesDir);){
            for (Path path : stream) {
                fpBuilder.addPackage(FeaturePackDescriber.processPackage(path, encoding));
            }
        }
        catch (IOException e) {
            FeaturePackDescriber.failedToReadDirectory(packagesDir, e);
        }
    }

    private static ConfigLayerSpec processLayer(Path layerDir, String encoding) throws ProvisioningDescriptionException {
        ConfigLayerSpec configLayerSpec;
        block10: {
            FeaturePackDescriber.assertDirectory(layerDir);
            Path layerXml = layerDir.resolve("layer-spec.xml");
            if (!Files.exists(layerXml, new LinkOption[0])) {
                throw new ProvisioningDescriptionException(BaseErrors.pathDoesNotExist((Path)layerXml));
            }
            BufferedReader in = Files.newBufferedReader(layerXml, Charset.forName(encoding));
            try {
                configLayerSpec = ConfigLayerSpecXmlParser.getInstance().parse(in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProvisioningDescriptionException(Errors.openFile(layerXml), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new ProvisioningDescriptionException(Errors.parseXml(layerXml), (Throwable)e);
                }
            }
            ((Reader)in).close();
        }
        return configLayerSpec;
    }

    private static FeatureSpec processFeature(Path featureDir, String encoding) throws ProvisioningDescriptionException {
        FeatureSpec featureSpec;
        block10: {
            FeaturePackDescriber.assertDirectory(featureDir);
            Path featureXml = featureDir.resolve("spec.xml");
            if (!Files.exists(featureXml, new LinkOption[0])) {
                throw new ProvisioningDescriptionException(BaseErrors.pathDoesNotExist((Path)featureXml));
            }
            BufferedReader in = Files.newBufferedReader(featureXml, Charset.forName(encoding));
            try {
                featureSpec = FeatureSpecXmlParser.getInstance().parse(in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProvisioningDescriptionException(Errors.openFile(featureXml), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new ProvisioningDescriptionException(Errors.parseXml(featureXml), (Throwable)e);
                }
            }
            ((Reader)in).close();
        }
        return featureSpec;
    }

    /*
     * Exception decompiling
     */
    private static void processConfigModel(Path configDir, String encoding, FeaturePackDescription.Builder fpBuilder) throws ProvisioningDescriptionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PackageSpec processPackage(Path pkgDir, String encoding) throws ProvisioningDescriptionException {
        PackageSpec packageSpec;
        block10: {
            FeaturePackDescriber.assertDirectory(pkgDir);
            Path pkgXml = pkgDir.resolve("package.xml");
            if (!Files.exists(pkgXml, new LinkOption[0])) {
                throw new ProvisioningDescriptionException(BaseErrors.pathDoesNotExist((Path)pkgXml));
            }
            BufferedReader in = Files.newBufferedReader(pkgXml, Charset.forName(encoding));
            try {
                packageSpec = PackageXmlParser.getInstance().parse(in);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProvisioningDescriptionException(Errors.openFile(pkgXml), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    throw new ProvisioningDescriptionException(Errors.parseXml(pkgXml), (Throwable)e);
                }
            }
            ((Reader)in).close();
        }
        return packageSpec;
    }

    private static void assertDirectory(Path dir) throws ProvisioningDescriptionException {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new ProvisioningDescriptionException(BaseErrors.notADir((Path)dir));
        }
    }

    private static void failedToReadDirectory(Path p, IOException e) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException(BaseErrors.readDirectory((Path)p), (Throwable)e);
    }
}

