/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.spec.PackageDependencySpec;
import org.jboss.galleon.spec.PackageSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

public class FeaturePackDescription {
    private final FeaturePackLocation.FPID fpid;
    private final FeaturePackSpec spec;
    private final Map<String, PackageSpec> packages;
    private final Map<String, ConfigLayerSpec> layers;
    private final Map<String, FeatureSpec> features;
    private final Map<String, Map<String, ConfigModel>> configModels;
    final List<String> unresolvedLocalPkgs;
    final boolean externalPkgDeps;

    public static Builder builder(FeaturePackSpec.Builder spec) {
        return new Builder(spec.getFPID(), spec);
    }

    private FeaturePackDescription(Builder builder) throws ProvisioningDescriptionException {
        this.fpid = builder.fpid;
        this.spec = builder.spec.build();
        this.packages = CollectionUtils.unmodifiable(builder.packages);
        for (String name : this.spec.getDefaultPackageNames()) {
            if (this.packages.containsKey(name)) continue;
            throw new ProvisioningDescriptionException(Errors.unknownPackage(this.fpid, name));
        }
        List<String> notFound = Collections.emptyList();
        boolean externalPkgDeps = false;
        if (!this.packages.isEmpty()) {
            for (PackageSpec pkg : this.packages.values()) {
                if (pkg.hasLocalPackageDeps()) {
                    for (PackageDependencySpec pkgDep : pkg.getLocalPackageDeps()) {
                        PackageSpec depSpec = this.packages.get(pkgDep.getName());
                        if (depSpec != null) continue;
                        if (notFound.isEmpty()) {
                            notFound = new ArrayList<String>();
                        }
                        notFound.add(pkgDep.getName());
                    }
                    if (!this.spec.hasFeaturePackDeps() && !notFound.isEmpty()) {
                        throw new ProvisioningDescriptionException(Errors.unsatisfiedPackageDependencies(this.fpid, pkg.getName(), notFound));
                    }
                }
                if (!pkg.hasExternalPackageDeps()) continue;
                for (String origin : pkg.getPackageOrigins()) {
                    try {
                        this.spec.getFeaturePackDep(origin);
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new ProvisioningDescriptionException(BaseErrors.unknownFeaturePackDependencyName((FeaturePackLocation.FPID)this.fpid, (String)pkg.getName(), (String)origin), (Throwable)e);
                    }
                }
                externalPkgDeps = true;
            }
        }
        this.layers = CollectionUtils.unmodifiable(builder.layers);
        this.features = CollectionUtils.unmodifiable(builder.features);
        this.configModels = CollectionUtils.unmodifiable(builder.configModels);
        this.externalPkgDeps = externalPkgDeps;
        this.unresolvedLocalPkgs = CollectionUtils.unmodifiable(notFound);
    }

    public FeaturePackLocation.FPID getFPID() {
        return this.fpid;
    }

    public FeaturePackSpec getSpec() {
        return this.spec;
    }

    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    public boolean hasPackage(String name) {
        return this.packages.containsKey(name);
    }

    public PackageSpec getPackage(String name) {
        return this.packages.get(name);
    }

    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    public Collection<PackageSpec> getPackages() {
        return this.packages.values();
    }

    public Collection<ConfigLayerSpec> getLayers() {
        return this.layers.values();
    }

    public Collection<FeatureSpec> getFeatures() {
        return this.features.values();
    }

    public Map<String, Map<String, ConfigModel>> getConfigs() {
        return this.configModels;
    }

    public static class Builder {
        private final FeaturePackLocation.FPID fpid;
        private final FeaturePackSpec.Builder spec;
        private Map<String, PackageSpec> packages = Collections.emptyMap();
        private Map<String, ConfigLayerSpec> layers = Collections.emptyMap();
        private Map<String, FeatureSpec> features = Collections.emptyMap();
        private Map<String, Map<String, ConfigModel>> configModels = Collections.emptyMap();

        private Builder(FeaturePackLocation.FPID fpid, FeaturePackSpec.Builder spec) {
            this.fpid = fpid;
            this.spec = spec;
        }

        public Builder addPackage(PackageSpec pkg) {
            this.packages = CollectionUtils.put(this.packages, (Object)pkg.getName(), (Object)pkg);
            return this;
        }

        public Builder addLayer(ConfigLayerSpec layer) {
            this.layers = CollectionUtils.put(this.layers, (Object)layer.getName(), (Object)layer);
            return this;
        }

        public Builder addFeature(FeatureSpec spec) {
            this.features = CollectionUtils.put(this.features, (Object)spec.getName(), (Object)spec);
            return this;
        }

        public boolean hasPackage(String name) {
            return this.packages.containsKey(name);
        }

        public FeaturePackSpec.Builder getSpecBuilder() {
            return this.spec;
        }

        public FeaturePackDescription build() throws ProvisioningDescriptionException {
            return new FeaturePackDescription(this);
        }

        public Builder addConfigModel(String modelName, Map<String, ConfigModel> configs) {
            this.configModels = CollectionUtils.put(this.configModels, (Object)modelName, configs);
            return this;
        }
    }
}

