/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.layout.FeaturePackUpdatePlan;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningPlan {
    private Map<FeaturePackLocation.ProducerSpec, FeaturePackConfig> install = Collections.emptyMap();
    private Set<FeaturePackLocation.ProducerSpec> uninstall = Collections.emptySet();
    private Map<FeaturePackLocation.ProducerSpec, FeaturePackUpdatePlan> updates = Collections.emptyMap();

    public static ProvisioningPlan builder() {
        return new ProvisioningPlan();
    }

    public ProvisioningPlan install(FeaturePackLocation fpl) throws ProvisioningDescriptionException {
        return this.install(FeaturePackConfig.forLocation(fpl));
    }

    public ProvisioningPlan install(FeaturePackConfig fpConfig) throws ProvisioningDescriptionException {
        FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
        if (this.uninstall.contains(producer) || this.updates.containsKey(producer)) {
            throw new ProvisioningDescriptionException(producer + " has already been added to the plan");
        }
        this.install = CollectionUtils.putLinked(this.install, (Object)producer, (Object)fpConfig);
        return this;
    }

    public ProvisioningPlan uninstall(FeaturePackLocation.ProducerSpec producer) throws ProvisioningDescriptionException {
        if (this.install.containsKey(producer) || this.updates.containsKey(producer)) {
            throw new ProvisioningDescriptionException(producer + " has already been added to the plan");
        }
        this.uninstall = CollectionUtils.add(this.uninstall, (Object)producer);
        return this;
    }

    public ProvisioningPlan update(FeaturePackUpdatePlan fpPlan) throws ProvisioningDescriptionException {
        FeaturePackLocation.ProducerSpec producer = fpPlan.getInstalledLocation().getProducer();
        if (this.install.containsKey(producer) || this.uninstall.contains(producer)) {
            throw new ProvisioningDescriptionException(producer + " has already been added to the plan");
        }
        this.updates = CollectionUtils.putLinked(this.updates, (Object)producer, (Object)fpPlan);
        return this;
    }

    public boolean hasInstall() {
        return !this.install.isEmpty();
    }

    public boolean hasUninstall() {
        return !this.uninstall.isEmpty();
    }

    public boolean hasUpdates() {
        return !this.updates.isEmpty();
    }

    public boolean isEmpty() {
        return this.install.isEmpty() && this.updates.isEmpty() && this.uninstall.isEmpty();
    }

    public Collection<FeaturePackConfig> getInstall() {
        return this.install.values();
    }

    public Collection<FeaturePackLocation.ProducerSpec> getUninstall() {
        return this.uninstall;
    }

    public Collection<FeaturePackUpdatePlan> getUpdates() {
        return this.updates.values();
    }

    Map<FeaturePackLocation.ProducerSpec, FeaturePackUpdatePlan> getUpdateMap() {
        return this.updates;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.install == null ? 0 : this.install.hashCode());
        result = 31 * result + (this.uninstall == null ? 0 : this.uninstall.hashCode());
        result = 31 * result + (this.updates == null ? 0 : this.updates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningPlan other = (ProvisioningPlan)obj;
        if (this.install == null ? other.install != null : !this.install.equals(other.install)) {
            return false;
        }
        if (this.uninstall == null ? other.uninstall != null : !this.uninstall.equals(other.uninstall)) {
            return false;
        }
        return !(this.updates == null ? other.updates != null : !this.updates.equals(other.updates));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (!this.install.isEmpty()) {
            buf.append("install ");
            StringUtils.append((StringBuilder)buf, this.getInstall());
            buf.append(';');
        }
        if (!this.uninstall.isEmpty()) {
            if (buf.length() > 1) {
                buf.append(' ');
            }
            buf.append("uninstall ");
            StringUtils.append((StringBuilder)buf, this.uninstall);
            buf.append(';');
        }
        if (!this.updates.isEmpty()) {
            if (buf.length() > 1) {
                buf.append(' ');
            }
            buf.append("update ");
            StringUtils.append((StringBuilder)buf, this.updates.values());
            buf.append(';');
        }
        return buf.toString();
    }
}

