/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.runtime.ConfigFeatureBranch;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.runtime.SpecFeatures;
import org.jboss.galleon.util.CollectionUtils;

class CapabilityProviders {
    List<SpecFeatures> specs = Collections.emptyList();
    List<ResolvedFeature> features = Collections.emptyList();
    private ConfigFeatureBranch firstProvided;
    Set<ConfigFeatureBranch> branches = Collections.emptySet();
    private List<ResolvedFeature> branchDependees = Collections.emptyList();

    CapabilityProviders() {
    }

    void addBranchDependee(ResolvedFeature feature) {
        this.branchDependees = CollectionUtils.add(this.branchDependees, (Object)feature);
    }

    void add(SpecFeatures specFeatures) {
        this.specs = CollectionUtils.add(this.specs, (Object)specFeatures);
        specFeatures.spec.addCapabilityProviders(this);
    }

    void add(ResolvedFeature feature) {
        this.features = CollectionUtils.add(this.features, (Object)feature);
        feature.addCapabilityProviders(this);
    }

    void provided(ConfigFeatureBranch branch) {
        if (this.firstProvided != null) {
            this.branches = CollectionUtils.add(this.branches, (Object)branch);
            return;
        }
        this.firstProvided = branch;
        this.branches = Collections.singleton(branch);
        if (!this.branchDependees.isEmpty()) {
            for (ResolvedFeature branchDependee : this.branchDependees) {
                branchDependee.addBranchDep(branch, false);
            }
            this.branchDependees = Collections.emptyList();
        }
    }

    boolean isProvided() {
        return !this.branches.isEmpty();
    }
}

