/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ResolvedFeature;
import org.jboss.galleon.util.CollectionUtils;

class ConfigFeatureBranch {
    final Object id;
    final boolean anonymous;
    private List<ResolvedFeature> list = new ArrayList<ResolvedFeature>();
    private boolean batch;
    private Set<ConfigFeatureBranch> deps = Collections.emptySet();
    private boolean ordered;
    private boolean fkBranch;
    private boolean specBranch;

    ConfigFeatureBranch(int index, boolean batch) {
        this.id = index;
        this.batch = batch;
        this.anonymous = true;
    }

    ConfigFeatureBranch(Object id, boolean batch) {
        this.id = id;
        this.batch = batch;
        this.anonymous = false;
    }

    List<ResolvedFeature> getFeatures() {
        return this.list;
    }

    boolean isEmpty() {
        return this.list.isEmpty();
    }

    boolean isBatch() {
        return this.batch;
    }

    void setBatch(boolean batch) throws ProvisioningException {
        if (!this.list.isEmpty()) {
            throw new ProvisioningException("Can't start batch in the middle of a branch");
        }
        this.batch = batch;
    }

    void setFkBranch() throws ProvisioningException {
        this.fkBranch = true;
    }

    boolean isFkBranch() {
        return this.fkBranch;
    }

    void setSpecBranch() throws ProvisioningException {
        this.specBranch = true;
    }

    boolean isSpecBranch() {
        return this.specBranch;
    }

    boolean hasDeps() {
        return !this.deps.isEmpty();
    }

    Set<ConfigFeatureBranch> getDeps() {
        return this.deps;
    }

    boolean dependsOn(ConfigFeatureBranch branch) {
        return this.deps.contains(branch);
    }

    void add(ResolvedFeature feature) throws ProvisioningException {
        feature.setBranch(this);
        this.list.add(feature);
    }

    void addBranchDep(ConfigFeatureBranch dep) {
        this.deps = CollectionUtils.add(this.deps, (Object)dep);
    }

    boolean isOrdered() {
        return this.ordered;
    }

    void ordered() {
        this.ordered = true;
        if (this.list.isEmpty()) {
            return;
        }
        ResolvedFeature feature = this.list.get(0);
        feature.startBranch();
        int size = this.list.size();
        if (this.batch && size > 1) {
            feature.startBatch();
        }
        feature = this.list.get(this.list.size() - 1);
        feature.endBranch();
        if (this.batch && size > 1) {
            feature.endBatch();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigFeatureBranch other = (ConfigFeatureBranch)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[id=").append(this.id);
        if (!this.deps.isEmpty()) {
            buf.append(" deps=");
            Iterator<ConfigFeatureBranch> i = this.deps.iterator();
            buf.append(i.next().id);
            while (i.hasNext()) {
                buf.append(',').append(i.next().id);
            }
        }
        return buf.append(']').toString();
    }
}

