/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.Stability;
import org.jboss.galleon.api.GalleonFeaturePackRuntime;
import org.jboss.galleon.api.GalleonPackageRuntime;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.runtime.FeaturePackRuntimeBuilder;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.state.FeaturePack;

public class FeaturePackRuntime
extends FeaturePackLayout
implements FeaturePack<PackageRuntime>,
GalleonFeaturePackRuntime {
    private final Map<String, PackageRuntime> packages;
    private final Map<String, ResolvedFeatureSpec> featureSpecs;

    FeaturePackRuntime(FeaturePackRuntimeBuilder builder, ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        super(builder.producer.getLocation().getFPID(), builder.getDir(), builder.getType());
        this.spec = builder.getSpec();
        this.featureSpecs = builder.featureSpecs == null ? Collections.emptyMap() : builder.featureSpecs;
        LinkedHashMap<String, PackageRuntime> tmpPackages = new LinkedHashMap<String, PackageRuntime>(builder.pkgOrder.size());
        switch (rt.includedPkgDeps) {
            case 0: {
                for (String pkgName : builder.pkgOrder) {
                    tmpPackages.put(pkgName, builder.pkgBuilders.get(pkgName).build(this));
                }
                break;
            }
            case 1: 
            case 2: {
                PackageRuntime.Builder pkgBuilder;
                int i;
                ArrayList<PackageRuntime> included = new ArrayList<PackageRuntime>(builder.pkgOrder.size());
                do {
                    i = included.size();
                    if (builder.pkgOrder.isEmpty()) break;
                    Iterator<String> pkgNames = builder.pkgOrder.descendingIterator();
                    while (pkgNames.hasNext()) {
                        String string = pkgNames.next();
                        pkgBuilder = builder.pkgBuilders.get(string);
                        if (pkgBuilder.isFlagOn(4)) {
                            included.add(pkgBuilder.build(this));
                            pkgNames.remove();
                            continue;
                        }
                        if (!pkgBuilder.isFlagOn(8) && !pkgBuilder.isFlagOn(16) || (rt.includedPkgDeps != 1 || !pkgBuilder.isPassiveWithSatisfiedDeps()) && (rt.includedPkgDeps != 2 || ((pkgBuilder.type & 1) <= 0 || pkgBuilder.type == 3) && !pkgBuilder.isPassiveWithSatisfiedDeps())) continue;
                        pkgBuilder.include();
                        included.add(pkgBuilder.build(this));
                        pkgNames.remove();
                    }
                } while (included.size() != i);
                while (--i >= 0) {
                    PackageRuntime pkg = (PackageRuntime)included.get(i);
                    tmpPackages.put(pkg.getName(), pkg);
                }
                break;
            }
            case 3: {
                PackageRuntime.Builder pkgBuilder;
                for (String string : builder.pkgOrder) {
                    pkgBuilder = builder.pkgBuilders.get(string);
                    if (!pkgBuilder.isFlagOn(4)) continue;
                    tmpPackages.put(string, pkgBuilder.build(this));
                }
                break;
            }
            default: {
                throw new ProvisioningException("Unexpected package dependency mask " + Integer.toBinaryString(rt.includedPkgDeps));
            }
        }
        LinkedHashMap<String, PackageRuntime> filteredPackages = new LinkedHashMap<String, PackageRuntime>(tmpPackages.size());
        Stability stability = rt.getPackageStability(this.getSpec().getPackageStability());
        for (Map.Entry entry : tmpPackages.entrySet()) {
            Stability packageStability;
            Stability stability2 = packageStability = ((PackageRuntime)entry.getValue()).getSpec().getStability() == null ? Stability.DEFAULT : ((PackageRuntime)entry.getValue()).getSpec().getStability();
            if (stability.enables(packageStability)) {
                filteredPackages.put((String)entry.getKey(), (PackageRuntime)entry.getValue());
                continue;
            }
            if (!rt.getMessageWriter().isVerboseEnabled()) continue;
            rt.getMessageWriter().verbose((CharSequence)("Excluding package '" + (String)entry.getKey() + "'. Its stability '" + packageStability + "' is lower than the expected '" + stability + "' stability"));
        }
        this.packages = Collections.unmodifiableMap(filteredPackages);
    }

    public Set<String> getSystemPaths() {
        return this.spec.getSystemPaths();
    }

    @Override
    public boolean hasPackages() {
        return !this.packages.isEmpty();
    }

    @Override
    public boolean containsPackage(String name) {
        return this.packages.containsKey(name);
    }

    @Override
    public Set<String> getPackageNames() {
        return this.packages.keySet();
    }

    @Override
    public Collection<PackageRuntime> getPackages() {
        return this.packages.values();
    }

    @Override
    public PackageRuntime getPackage(String name) {
        return this.packages.get(name);
    }

    public GalleonPackageRuntime getGalleonPackage(String name) {
        return this.packages.get(name);
    }

    public Collection<GalleonPackageRuntime> getGalleonPackages() {
        ArrayList<GalleonPackageRuntime> lst = new ArrayList<GalleonPackageRuntime>();
        for (PackageRuntime rt : this.packages.values()) {
            lst.add(rt);
        }
        return lst;
    }

    public Set<String> getFeatureSpecNames() {
        return this.featureSpecs.keySet();
    }

    public Collection<ResolvedFeatureSpec> getFeatureSpecs() {
        return this.featureSpecs.values();
    }

    public FeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        if (this.featureSpecs.containsKey(name)) {
            return this.featureSpecs.get((Object)name).xmlSpec;
        }
        return this.loadFeatureSpec(name);
    }

    public ResolvedFeatureSpec getResolvedFeatureSpec(String name) throws ProvisioningDescriptionException {
        return this.featureSpecs.get(name);
    }
}

