/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.BaseErrors;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.UnsatisfiedPackageDependencyException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntimeBuilder;
import org.jboss.galleon.runtime.ResolvedFeatureSpec;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.spec.ConfigLayerSpec;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.type.ParameterTypeProvider;
import org.jboss.galleon.type.builtin.BuiltInParameterTypeProvider;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.xml.ConfigXmlParser;
import org.jboss.galleon.xml.FeatureGroupXmlParser;
import org.jboss.galleon.xml.FeatureSpecXmlParser;
import org.jboss.galleon.xml.PackageXmlParser;
import org.jboss.galleon.xml.XmlParsers;

public class FeaturePackRuntimeBuilder
extends FeaturePackLayout {
    static final int VISIT = 1;
    static final int RESOLVE_LAYER = 2;
    static final int RESOLVE_MODEL_ONLY_CONFIG = 4;
    final FeaturePackLocation.ProducerSpec producer;
    Map<String, ResolvedFeatureSpec> featureSpecs = null;
    private Map<String, FeatureGroup> fgSpecs = null;
    private Map<ConfigId, ConfigModel> configs = null;
    private Map<ConfigId, ConfigLayerSpec> layers = null;
    Map<String, PackageRuntime.Builder> pkgBuilders = Collections.emptyMap();
    LinkedList<String> pkgOrder = new LinkedList();
    private ParameterTypeProvider featureParamTypeProvider = BuiltInParameterTypeProvider.getInstance();
    private int flags;

    public FeaturePackRuntimeBuilder(FeaturePackLocation.FPID fpid, FeaturePackSpec spec, Path dir, int type) {
        super(fpid, dir, type);
        this.producer = fpid.getProducer();
        this.dir = dir;
        this.spec = spec;
    }

    boolean isFlagOn(int flag) {
        return (this.flags & flag) > 0;
    }

    boolean setFlag(int flag) {
        if ((this.flags & flag) > 0) {
            return false;
        }
        this.flags ^= flag;
        return true;
    }

    int clearFlag(int flag) {
        if ((this.flags & flag) > 0) {
            this.flags ^= flag;
        }
        return this.flags;
    }

    int getFlags() {
        return this.flags;
    }

    boolean resolvePackage(String pkgName, ProvisioningRuntimeBuilder rt, PackageRuntime.Builder parent, int type) throws ProvisioningException {
        PackageRuntime.Builder pkgBuilder = this.pkgBuilders.get(pkgName);
        if (pkgBuilder == null) {
            Path pkgDir = LayoutUtils.getPackageDir(this.dir, pkgName, false);
            if (!Files.exists(pkgDir, new LinkOption[0])) {
                return false;
            }
            Path pkgXml = pkgDir.resolve("package.xml");
            if (!Files.exists(pkgXml, new LinkOption[0])) {
                throw new ProvisioningDescriptionException(BaseErrors.pathDoesNotExist((Path)pkgXml));
            }
            try (BufferedReader reader = Files.newBufferedReader(pkgXml);){
                pkgBuilder = PackageRuntime.builder(this, PackageXmlParser.getInstance().parse(reader), pkgDir, ++rt.pkgsTotal);
            }
            catch (IOException | XMLStreamException e) {
                throw new ProvisioningException(Errors.parseXml(pkgXml), (Throwable)e);
            }
            if (!pkgBuilder.spec.getName().equals(pkgName)) {
                throw new ProvisioningDescriptionException("Feature-pack " + this.getFPID() + " package spec name " + pkgBuilder.spec.getName() + " does not match the requested package name " + pkgName);
            }
            this.pkgBuilders = CollectionUtils.put(this.pkgBuilders, (Object)pkgName, (Object)pkgBuilder);
        }
        pkgBuilder.referencedAs(type);
        if (parent == null) {
            pkgBuilder.setFlag(16);
            if (type == 4) {
                pkgBuilder.include();
            }
        } else if (!parent.isFlagOn(2)) {
            parent.addPackageDep(pkgBuilder, type, rt.includedPkgDeps);
        }
        if (!rt.addToPkgDepBranch(pkgBuilder)) {
            return true;
        }
        if (pkgBuilder.spec.hasPackageDeps()) {
            FeaturePackRuntimeBuilder currentOrigin = rt.setOrigin(this);
            try {
                rt.processPackageDeps(pkgBuilder.spec, pkgBuilder);
            }
            catch (UnsatisfiedPackageDependencyException e) {
                throw new UnsatisfiedPackageDependencyException(this.getFPID(), pkgName, e);
            }
            catch (ProvisioningException e) {
                throw new ProvisioningException(Errors.resolvePackage(this.getFPID(), pkgName), (Throwable)e);
            }
            finally {
                rt.setOrigin(currentOrigin);
            }
        }
        return true;
    }

    FeatureGroup getFeatureGroupSpec(String name) throws ProvisioningException {
        FeatureGroup featureGroup;
        block12: {
            FeatureGroup fgSpec;
            if (this.fgSpecs != null && (fgSpec = this.fgSpecs.get(name)) != null) {
                return fgSpec;
            }
            Path specXml = this.dir.resolve("feature_groups").resolve(name + ".xml");
            if (!Files.exists(specXml, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(specXml);
            try {
                FeatureGroup fgSpec2 = FeatureGroupXmlParser.getInstance().parse(reader);
                if (!fgSpec2.getName().equals(name)) {
                    throw new ProvisioningDescriptionException("Feature-pack " + this.getFPID() + " feature group " + fgSpec2.getName() + " does not match the requested feature group name " + name);
                }
                if (this.fgSpecs == null) {
                    this.fgSpecs = new HashMap<String, FeatureGroup>();
                }
                this.fgSpecs.put(name, fgSpec2);
                featureGroup = fgSpec2;
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProvisioningException(Errors.parseXml(specXml), (Throwable)e);
                }
            }
            reader.close();
        }
        return featureGroup;
    }

    ConfigModel getConfig(ConfigId configId) throws ProvisioningException {
        ConfigModel configModel;
        block11: {
            ConfigModel config;
            if (this.configs != null && (config = this.configs.get(configId)) != null) {
                return config;
            }
            Path p = LayoutUtils.getConfigXml(this.dir, configId, false);
            if (!Files.exists(p, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(p);
            try {
                ConfigModel config2 = ConfigXmlParser.getInstance().parse(reader);
                if (this.configs == null) {
                    this.configs = new HashMap<ConfigId, ConfigModel>();
                }
                this.configs.put(config2.getId(), config2);
                configModel = config2;
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProvisioningException(Errors.parseXml(p), (Throwable)e);
                }
            }
            reader.close();
        }
        return configModel;
    }

    ConfigLayerSpec getConfigLayer(ConfigId configId) throws ProvisioningException {
        ConfigLayerSpec layer;
        if (this.layers != null && (layer = this.layers.get(configId)) != null) {
            return layer;
        }
        Path p = LayoutUtils.getLayerSpecXml(this.dir, configId.getModel(), configId.getName(), false);
        if (!Files.exists(p, new LinkOption[0])) {
            return null;
        }
        ConfigLayerSpec layer2 = XmlParsers.parseConfigLayerSpec(p, configId.getModel());
        if (this.layers == null) {
            this.layers = new HashMap<ConfigId, ConfigLayerSpec>();
        }
        this.layers.put(configId, layer2);
        return layer2;
    }

    public ResolvedFeatureSpec getFeatureSpec(String name) throws ProvisioningException {
        ResolvedFeatureSpec resolvedFeatureSpec;
        block12: {
            ResolvedFeatureSpec resolvedSpec;
            if (this.featureSpecs != null && (resolvedSpec = this.featureSpecs.get(name)) != null) {
                return resolvedSpec;
            }
            Path specXml = this.dir.resolve("features").resolve(name).resolve("spec.xml");
            if (!Files.exists(specXml, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(specXml);
            try {
                FeatureSpec xmlSpec = FeatureSpecXmlParser.getInstance().parse(reader);
                if (!xmlSpec.getName().equals(name)) {
                    throw new ProvisioningDescriptionException("Feature-pack " + this.getFPID() + " feature spec " + xmlSpec.getName() + " does not match the requested feature spec name " + name);
                }
                ResolvedFeatureSpec resolvedSpec2 = new ResolvedFeatureSpec(new ResolvedSpecId(this.producer, xmlSpec.getName()), this.featureParamTypeProvider, xmlSpec);
                if (this.featureSpecs == null) {
                    this.featureSpecs = new HashMap<String, ResolvedFeatureSpec>();
                }
                this.featureSpecs.put(name, resolvedSpec2);
                resolvedFeatureSpec = resolvedSpec2;
                if (reader == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ProvisioningDescriptionException(Errors.parseXml(specXml), (Throwable)e);
                }
            }
            reader.close();
        }
        return resolvedFeatureSpec;
    }

    FeaturePackRuntime build(ProvisioningRuntimeBuilder rt) throws ProvisioningException {
        return new FeaturePackRuntime(this, rt);
    }
}

