/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

class FpStack {
    private static final int INHERIT_PKGS_FALSE = -1;
    private static final int INHERIT_PKGS_NOT_FOUND = 0;
    private static final int INHERIT_PKGS_TRANSITIVE = 1;
    private static final int INHERIT_PKGS_TRUE = 2;
    private final ProvisioningConfig config;
    private List<Level> levels = new ArrayList<Level>();
    private Level lastPushed;

    FpStack(ProvisioningConfig config) {
        this.config = config;
    }

    boolean push(FeaturePackConfig fpConfig, boolean extendCurrentLevel) {
        if (!this.isRelevant(fpConfig)) {
            return false;
        }
        if (extendCurrentLevel) {
            this.lastPushed.addFpConfig(fpConfig);
            return true;
        }
        Level newLevel = new Level();
        newLevel.addFpConfig(fpConfig);
        this.levels.add(newLevel);
        this.lastPushed = newLevel;
        return true;
    }

    void popLevel() {
        if (this.isEmpty()) {
            return;
        }
        if (this.levels.size() == 1) {
            this.levels.clear();
            this.lastPushed = null;
        } else {
            this.levels.remove(this.levels.size() - 1);
            this.lastPushed = this.levels.get(this.levels.size() - 1);
        }
    }

    boolean isEmpty() {
        return this.lastPushed == null;
    }

    boolean hasNext() {
        if (this.lastPushed == null) {
            return false;
        }
        return this.lastPushed.hasNext();
    }

    FeaturePackConfig next() {
        if (this.lastPushed == null) {
            throw new NoSuchElementException();
        }
        return this.lastPushed.next();
    }

    boolean isFilteredOut(FeaturePackLocation.ProducerSpec producer, ConfigId configId, boolean fromPrevLevel) {
        Boolean filteredOut = FpStack.isFilteredOut(this.config, configId);
        if (filteredOut != null) {
            return filteredOut;
        }
        return this.isFilteredOutFromDeps(producer, configId, fromPrevLevel);
    }

    boolean isFilteredOutFromDeps(FeaturePackLocation.ProducerSpec producer, ConfigId configId, boolean fromPrevLevel) {
        Boolean included;
        Level level;
        int last = this.levels.size() - (fromPrevLevel ? 1 : 0);
        int i = 0;
        int notInheritingLevel = Integer.MAX_VALUE;
        Boolean notInherited = null;
        block0: while (i < last) {
            level = this.levels.get(i);
            FeaturePackConfig levelFpConfig = level.getCurrentConfig();
            FeaturePackLocation.ProducerSpec levelProducer = levelFpConfig.getLocation().getProducer();
            for (int j = 0; j <= Math.min(i, notInheritingLevel); ++j) {
                FeaturePackConfig transitiveFpConfig = this.levels.get((int)j).transitive.get(levelProducer);
                if (transitiveFpConfig == null) continue;
                Boolean excluded = FpStack.isFilteredOut(transitiveFpConfig, configId);
                if (excluded != null) {
                    return excluded;
                }
                if (transitiveFpConfig.getInheritConfigs() == null) continue;
                if (j <= notInheritingLevel) {
                    notInheritingLevel = j;
                    notInherited = transitiveFpConfig.getInheritConfigs() == false;
                }
                ++i;
                continue block0;
            }
            FeaturePackConfig transitiveFpConfig = level.transitive.get(producer);
            if (transitiveFpConfig != null) {
                included = FpStack.isIncluded(transitiveFpConfig, configId);
                if (included != null && included.booleanValue()) {
                    return false;
                }
                if (transitiveFpConfig.getInheritConfigs() != null) {
                    ++i;
                    continue;
                }
            }
            if (notInherited == null) {
                notInherited = FpStack.isExcluded(levelFpConfig, configId);
                notInheritingLevel = i;
            }
            ++i;
        }
        if (notInherited != null && notInherited.booleanValue()) {
            return true;
        }
        block2: while (i > 0) {
            Boolean excluded;
            level = this.levels.get(--i);
            FeaturePackLocation.ProducerSpec levelProducer = level.getCurrentConfig().getLocation().getProducer();
            for (int j = 0; j <= i; ++j) {
                FeaturePackConfig fpConfig = this.levels.get((int)j).transitive.get(levelProducer);
                if (fpConfig == null) continue;
                included = FpStack.isIncluded(fpConfig, configId);
                if (included != null && included.booleanValue()) {
                    return false;
                }
                if (fpConfig.getInheritConfigs() != null) continue block2;
            }
            FeaturePackConfig transitiveFpConfig = level.transitive.get(producer);
            if (transitiveFpConfig != null) {
                Boolean included2 = FpStack.isIncluded(transitiveFpConfig, configId);
                if (included2 != null && included2.booleanValue()) {
                    return false;
                }
                if (transitiveFpConfig.getInheritConfigs() != null) continue;
            }
            if ((excluded = level.isExcluded(producer, configId)) == null) continue;
            return excluded;
        }
        return false;
    }

    private static Boolean isFilteredOut(ConfigCustomizations configCustoms, ConfigId configId) {
        if (configId.isModelOnly()) {
            return configCustoms.isConfigModelExcluded(configId) || !configCustoms.isInheritModelOnlyConfigs();
        }
        if (configCustoms.isConfigExcluded(configId)) {
            return true;
        }
        if (configCustoms.isConfigIncluded(configId)) {
            return false;
        }
        if (configCustoms.isConfigModelExcluded(configId)) {
            if (configCustoms.isConfigIncluded(configId)) {
                return false;
            }
            return true;
        }
        if (configCustoms.isConfigModelIncluded(configId)) {
            if (configCustoms.isConfigExcluded(configId)) {
                return true;
            }
            return false;
        }
        Boolean inheritConfigs = configCustoms.getInheritConfigs();
        return inheritConfigs == null || inheritConfigs != false ? null : Boolean.valueOf(true);
    }

    boolean isIncludedInTransitiveDeps(FeaturePackLocation.ProducerSpec producer, ConfigId configId) {
        int end = this.levels.size() - 1;
        int i = 0;
        while (i < end) {
            Level level = this.levels.get(i++);
            FeaturePackLocation.ProducerSpec levelProducer = level.getCurrentConfig().getLocation().getProducer();
            for (int j = 0; j <= i; ++j) {
                Boolean included = this.levels.get(j).isIncludedInTransitive(levelProducer, configId);
                if (included == null) continue;
                return included;
            }
        }
        return false;
    }

    private static Boolean isIncluded(ConfigCustomizations configCustoms, ConfigId configId) {
        if (configId.isModelOnly()) {
            return configCustoms.isConfigModelIncluded(configId) || configCustoms.isInheritModelOnlyConfigs();
        }
        if (configCustoms.isConfigIncluded(configId)) {
            return true;
        }
        if (configCustoms.isConfigExcluded(configId)) {
            return false;
        }
        if (configCustoms.isConfigModelIncluded(configId)) {
            if (configCustoms.isConfigExcluded(configId)) {
                return false;
            }
            return true;
        }
        if (configCustoms.isConfigModelExcluded(configId)) {
            if (configCustoms.isConfigIncluded(configId)) {
                return true;
            }
            return false;
        }
        Boolean inheritConfigs = configCustoms.getInheritConfigs();
        return inheritConfigs == null || inheritConfigs != false ? null : Boolean.valueOf(false);
    }

    private static Boolean isExcluded(ConfigCustomizations configCustoms, ConfigId configId) {
        if (configId.isModelOnly()) {
            return configCustoms.isConfigModelExcluded(configId) || !configCustoms.isInheritModelOnlyConfigs();
        }
        if (configCustoms.isConfigIncluded(configId)) {
            return false;
        }
        if (configCustoms.isConfigExcluded(configId)) {
            return true;
        }
        if (configCustoms.isConfigModelIncluded(configId)) {
            if (configCustoms.isConfigExcluded(configId)) {
                return true;
            }
            return false;
        }
        if (configCustoms.isConfigModelExcluded(configId)) {
            if (configCustoms.isConfigIncluded(configId)) {
                return false;
            }
            return true;
        }
        Boolean inheritConfigs = configCustoms.getInheritConfigs();
        return inheritConfigs == null || inheritConfigs != false ? null : Boolean.valueOf(true);
    }

    private boolean isRelevant(FeaturePackConfig fpConfig) {
        if (this.isEmpty()) {
            return true;
        }
        FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
        int inheritPkgs = this.isInheritPackages(producer);
        if (inheritPkgs == 0 || inheritPkgs == 1 && !fpConfig.isTransitive()) {
            return true;
        }
        if (inheritPkgs > 0) {
            if (fpConfig.hasExcludedPackages()) {
                for (String excluded : fpConfig.getExcludedPackages()) {
                    if (this.isPackageExcluded(producer, excluded) || this.isPackageIncluded(producer, excluded)) continue;
                    return true;
                }
            }
            if (fpConfig.hasIncludedPackages()) {
                for (String included : fpConfig.getIncludedPackages()) {
                    if (this.isPackageIncluded(producer, included) || this.isPackageExcluded(producer, included)) continue;
                    return true;
                }
            }
        }
        if (fpConfig.hasDefinedConfigs()) {
            boolean configsInherited = true;
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                if (this.levels.get(i).isInheritConfigs()) continue;
                configsInherited = false;
                break;
            }
            if (configsInherited) {
                return true;
            }
        }
        if (fpConfig.hasModelOnlyConfigs()) {
            boolean configsInherited = true;
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                if (this.levels.get(i).isInheritModelOnlyConfigs()) continue;
                configsInherited = false;
                break;
            }
            if (configsInherited) {
                return true;
            }
        }
        return false;
    }

    private int isInheritPackages(FeaturePackLocation.ProducerSpec producer) {
        int result = 0;
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            int levelResult = this.levels.get(i).isInheritPackages(producer);
            if (levelResult < 0) {
                return levelResult;
            }
            if (levelResult <= result) continue;
            result = levelResult;
        }
        return result;
    }

    boolean isPackageExcluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).isPackageExcluded(producer, packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isPackageIncluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).isPackageIncluded(producer, packageName)) continue;
            return true;
        }
        return false;
    }

    boolean isPackageFilteredOut(FeaturePackLocation.ProducerSpec producer, String packageName) {
        int levelsTotal = this.levels.size();
        if (levelsTotal == 0) {
            return false;
        }
        Level level = this.levels.get(0);
        Boolean filteredOut = level.isPackageFilteredOut(producer, packageName);
        if (filteredOut != null) {
            return filteredOut;
        }
        if (levelsTotal == 1) {
            return false;
        }
        Boolean inheritPackages = level.getInheritPackages();
        block0: for (int i = 1; i < levelsTotal; ++i) {
            level = this.levels.get(i);
            FeaturePackLocation.ProducerSpec currentFpProducer = level.getCurrentConfig().getLocation().getProducer();
            for (int j = 0; j < i; ++j) {
                FeaturePackConfig transitiveFpConfig = this.levels.get((int)j).transitive.get(currentFpProducer);
                if (transitiveFpConfig == null) continue;
                Boolean transitiveInheritPackages = transitiveFpConfig.getInheritPackages();
                if (transitiveInheritPackages == null) break;
                if (transitiveInheritPackages.booleanValue()) continue block0;
                return true;
            }
            if (inheritPackages != null && !inheritPackages.booleanValue()) {
                return true;
            }
            filteredOut = level.isPackageFilteredOut(producer, packageName);
            if (filteredOut != null) {
                return filteredOut;
            }
            inheritPackages = level.getInheritPackages();
        }
        return false;
    }

    private static class Level {
        private List<FeaturePackConfig> fpConfigs = Collections.emptyList();
        private Map<FeaturePackLocation.ProducerSpec, FeaturePackConfig> transitive = Collections.emptyMap();
        private int currentFp = -1;

        private Level() {
        }

        void addFpConfig(FeaturePackConfig fpConfig) {
            this.fpConfigs = CollectionUtils.add(this.fpConfigs, (Object)fpConfig);
            if (fpConfig.isTransitive()) {
                this.transitive = CollectionUtils.put(this.transitive, (Object)fpConfig.getLocation().getProducer(), (Object)fpConfig);
            }
        }

        boolean hasNext() {
            return this.currentFp + 1 < this.fpConfigs.size();
        }

        FeaturePackConfig next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException(this.currentFp + 1 + " exceeded " + this.fpConfigs.size());
            }
            return this.fpConfigs.get(++this.currentFp);
        }

        FeaturePackConfig getCurrentConfig() {
            return this.fpConfigs.get(this.currentFp);
        }

        Boolean isExcluded(FeaturePackLocation.ProducerSpec producer, ConfigId configId) {
            return FpStack.isExcluded(this.fpConfigs.get(this.currentFp), configId);
        }

        Boolean isIncludedInTransitive(FeaturePackLocation.ProducerSpec producer, ConfigId configId) {
            FeaturePackConfig fpConfig = this.transitive.get(producer);
            return fpConfig == null ? null : FpStack.isIncluded(this.fpConfigs.get(this.currentFp), configId);
        }

        boolean isInheritConfigs() {
            return this.fpConfigs.get(this.currentFp).isInheritConfigs(true);
        }

        boolean isInheritModelOnlyConfigs() {
            return this.fpConfigs.get(this.currentFp).isInheritModelOnlyConfigs();
        }

        private Boolean getInheritPackages() {
            return this.fpConfigs.get(this.currentFp).getInheritPackages();
        }

        int isInheritPackages(FeaturePackLocation.ProducerSpec producer) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            if (fpConfig == null) {
                return 0;
            }
            if (!fpConfig.isInheritPackages(true)) {
                return -1;
            }
            return fpConfig.isTransitive() ? 1 : 2;
        }

        boolean isPackageExcluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            return fpConfig == null ? false : fpConfig.isPackageExcluded(packageName);
        }

        boolean isPackageIncluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            return fpConfig == null ? false : fpConfig.isPackageIncluded(packageName);
        }

        Boolean isPackageFilteredOut(FeaturePackLocation.ProducerSpec producer, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            if (fpConfig == null) {
                return null;
            }
            if (fpConfig.isPackageExcluded(packageName)) {
                return true;
            }
            if (fpConfig.isPackageIncluded(packageName)) {
                return false;
            }
            Boolean inheritPackages = fpConfig.getInheritPackages();
            return inheritPackages == null ? null : Boolean.valueOf(inheritPackages == false);
        }

        private FeaturePackConfig getFpConfig(FeaturePackLocation.ProducerSpec producer) {
            for (int i = this.fpConfigs.size() - 1; i >= 0; --i) {
                FeaturePackConfig fpConfig = this.fpConfigs.get(i);
                if (!fpConfig.getLocation().getProducer().equals((Object)producer)) continue;
                return fpConfig;
            }
            return null;
        }
    }
}

