/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ResolvedFeatureId {
    final ResolvedSpecId specId;
    final Map<String, Object> params;
    final Boolean child;
    private final int hash;

    public static Builder builder(ResolvedSpecId specId) {
        return new Builder(specId);
    }

    public static Builder builder(FeaturePackLocation.ProducerSpec producer, String spec) {
        return new Builder(producer, spec);
    }

    public static ResolvedFeatureId fromString(String str) throws ProvisioningDescriptionException {
        int equals;
        int colon;
        int i;
        int length = str.length();
        if (length == 0) {
            ResolvedFeatureId.formatException(str);
        }
        if (str.charAt(0) != '{') {
            ResolvedFeatureId.formatException(str);
        }
        if ((i = str.indexOf(125, 1)) < 0) {
            ResolvedFeatureId.formatException(str);
        }
        if ((colon = str.indexOf(58, i + 1)) - i < 2) {
            ResolvedFeatureId.formatException(str);
        }
        ResolvedSpecId specId = null;
        try {
            specId = new ResolvedSpecId(FeaturePackLocation.fromString((String)str.substring(1, i)).getProducer(), str.substring(i + 1, colon));
        }
        catch (IllegalArgumentException e) {
            throw new ProvisioningDescriptionException("Failed to parse the channel part of feature id '" + str + "'", (Throwable)e);
        }
        int endIndex = str.indexOf(44, colon + 3);
        if (endIndex < 0) {
            int equals2 = str.indexOf(61, colon + 1);
            if (equals2 < 0 || equals2 == str.length() - 1) {
                ResolvedFeatureId.formatException(str);
            }
            return new ResolvedFeatureId(specId, Collections.singletonMap(str.substring(colon + 1, equals2), str.substring(equals2 + 1)));
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        int lastComma = colon;
        while (endIndex > 0) {
            equals = str.indexOf(61, lastComma + 1);
            if (equals < 0 || equals == str.length() - 1) {
                ResolvedFeatureId.formatException(str);
            }
            params.put(str.substring(lastComma + 1, equals), str.substring(equals + 1, endIndex));
            lastComma = endIndex;
            endIndex = str.indexOf(44, endIndex + 1);
        }
        equals = str.indexOf(61, lastComma + 2);
        if (equals < 0 || equals == str.length() - 1) {
            ResolvedFeatureId.formatException(str);
        }
        params.put(str.substring(lastComma + 1, equals), str.substring(equals + 1));
        return new ResolvedFeatureId(specId, params);
    }

    public static ResolvedFeatureId fromGalleon1String(String str) throws ProvisioningDescriptionException {
        int equals;
        int endIndex;
        int length = str.length();
        if (length == 0) {
            ResolvedFeatureId.formatException(str);
        }
        int nextIndex = 0;
        char c = str.charAt(nextIndex++);
        StringBuilder buf = new StringBuilder(length);
        ResolvedSpecId specId = null;
        String groupId = null;
        String artifactId = null;
        String version = null;
        while (nextIndex < length) {
            if (c == '#') {
                if (artifactId == null || version != null || buf.length() == 0) {
                    ResolvedFeatureId.formatException(str);
                }
                version = buf.toString();
                buf.setLength(0);
            } else if (c == ':') {
                if (buf.length() == 0) {
                    ResolvedFeatureId.formatException(str);
                }
                if (groupId == null) {
                    groupId = buf.toString();
                } else if (artifactId == null) {
                    artifactId = buf.toString();
                } else if (version == null) {
                    ResolvedFeatureId.formatException(str);
                } else {
                    specId = new ResolvedSpecId(LegacyGalleon1Universe.toFpl(groupId, artifactId, version).getProducer(), buf.toString());
                    break;
                }
                buf.setLength(0);
            } else {
                buf.append(c);
            }
            c = str.charAt(nextIndex++);
        }
        if (specId == null) {
            ResolvedFeatureId.formatException(str);
        }
        if ((endIndex = str.indexOf(44, nextIndex + 3)) < 0) {
            int equals2 = str.indexOf(61, nextIndex + 1);
            if (equals2 < 0 || equals2 == str.length() - 1) {
                ResolvedFeatureId.formatException(str);
            }
            return new ResolvedFeatureId(specId, Collections.singletonMap(str.substring(nextIndex, equals2), str.substring(equals2 + 1)));
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        int lastComma = nextIndex - 1;
        while (endIndex > 0) {
            equals = str.indexOf(61, lastComma + 2);
            if (equals < 0 || equals == str.length() - 1) {
                ResolvedFeatureId.formatException(str);
            }
            params.put(str.substring(lastComma + 1, equals), str.substring(equals + 1, endIndex));
            lastComma = endIndex;
            endIndex = str.indexOf(44, endIndex + 1);
        }
        equals = str.indexOf(61, lastComma + 2);
        if (equals < 0 || equals == str.length() - 1) {
            ResolvedFeatureId.formatException(str);
        }
        params.put(str.substring(lastComma + 1, equals), str.substring(equals + 1));
        return new ResolvedFeatureId(specId, params);
    }

    private static void formatException(String str) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException("'" + str + "' does not follow format {producer[@universe]:channel}spec_name:param_name=value(,param_name=value)*");
    }

    public static ResolvedFeatureId create(FeaturePackLocation.ProducerSpec producer, String spec, String param, String value) {
        return new ResolvedFeatureId(new ResolvedSpecId(producer, spec), Collections.singletonMap(param, value));
    }

    public static ResolvedFeatureId create(ResolvedSpecId specId, String param, String value) {
        return new ResolvedFeatureId(specId, Collections.singletonMap(param, value));
    }

    ResolvedFeatureId(ResolvedSpecId specId, Map<String, Object> params) {
        this(specId, params, null);
    }

    ResolvedFeatureId(ResolvedSpecId specId, Map<String, Object> params, Boolean child) {
        this.specId = specId;
        Map filtered = Collections.emptyMap();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if ("GLN_UNDEFINED".equals(entry.getValue())) continue;
            filtered = CollectionUtils.put(filtered, (Object)entry.getKey(), (Object)entry.getValue());
        }
        if (filtered.isEmpty()) {
            filtered = params;
        }
        this.params = CollectionUtils.unmodifiable(filtered);
        this.child = child;
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.params.hashCode();
        this.hash = hash = 31 * hash + this.specId.hashCode();
    }

    public ResolvedSpecId getSpecId() {
        return this.specId;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    boolean isChildRef() {
        return this.child != null && this.child != false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolvedFeatureId other = (ResolvedFeatureId)obj;
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        return !(this.specId == null ? other.specId != null : !this.specId.equals(other.specId));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.specId);
        if (!this.params.isEmpty()) {
            buf.append(':');
            StringUtils.append((StringBuilder)buf, this.params.entrySet());
        }
        return buf.toString();
    }

    public static class Builder {
        private final ResolvedSpecId specId;
        private Map<String, Object> params = Collections.emptyMap();

        private Builder(FeaturePackLocation.ProducerSpec producer, String spec) {
            this.specId = new ResolvedSpecId(producer, spec);
        }

        private Builder(ResolvedSpecId specId) {
            this.specId = specId;
        }

        public Builder setParam(String name, Object value) {
            this.params = CollectionUtils.put(this.params, (Object)name, (Object)value);
            return this;
        }

        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        public ResolvedFeatureId build() throws ProvisioningDescriptionException {
            if (this.params.isEmpty()) {
                throw new ProvisioningDescriptionException("Failed to create an instance of ResolvedFeatureId for " + this.specId + ": params have not been initialized");
            }
            return new ResolvedFeatureId(this.specId, this.params);
        }
    }
}

