/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.CapabilityResolver;
import org.jboss.galleon.util.CollectionUtils;

public class CapabilitySpec {
    private final String[] elems;
    private final Boolean[] isElemStatic;
    private final boolean optional;

    public static CapabilitySpec fromString(String str) throws ProvisioningDescriptionException {
        return CapabilitySpec.fromString(str, false);
    }

    public static CapabilitySpec fromString(String str, boolean optional) throws ProvisioningDescriptionException {
        if (str == null) {
            throw new ProvisioningDescriptionException("str is null");
        }
        if (str.isEmpty()) {
            throw new ProvisioningDescriptionException("str is empty");
        }
        List elems = Collections.emptyList();
        List isElemStatic = Collections.emptyList();
        int strI = 0;
        StringBuilder buf = new StringBuilder();
        boolean isStatic = true;
        block4: while (strI < str.length()) {
            char ch = str.charAt(strI++);
            switch (ch) {
                case '.': {
                    if (buf.length() == 0) {
                        CapabilitySpec.formatError(str);
                    }
                    if (isStatic) {
                        if (buf.charAt(buf.length() - 1) == '.') {
                            CapabilitySpec.formatError(str);
                        }
                        if (strI < str.length() && str.charAt(strI) != '$') {
                            buf.append('.');
                            continue block4;
                        }
                    }
                    elems = CollectionUtils.add((List)elems, (Object)buf.toString());
                    isElemStatic = CollectionUtils.add((List)isElemStatic, (Object)isStatic);
                    buf.setLength(0);
                    isStatic = true;
                    continue block4;
                }
                case '$': {
                    if (strI > 1 && str.charAt(strI - 2) != '.') {
                        CapabilitySpec.formatError(str);
                    }
                    isStatic = false;
                    continue block4;
                }
            }
            if (Character.isWhitespace(ch)) {
                throw new ProvisioningDescriptionException("Whitespaces are not allowed in a capability expression '" + str + "'");
            }
            buf.append(ch);
        }
        if (buf.length() == 0) {
            CapabilitySpec.formatError(str);
        }
        elems = CollectionUtils.add(elems, (Object)buf.toString());
        isElemStatic = CollectionUtils.add(isElemStatic, (Object)isStatic);
        return new CapabilitySpec(elems, isElemStatic, optional);
    }

    private static void formatError(String str) throws ProvisioningDescriptionException {
        throw new ProvisioningDescriptionException("Capability '" + str + "' doesn't follow format [$]part[.[$]part]");
    }

    private CapabilitySpec(List<String> elems, List<Boolean> elemTypes, boolean optional) throws ProvisioningDescriptionException {
        this.elems = elems.toArray(new String[elems.size()]);
        this.isElemStatic = elemTypes.toArray(new Boolean[elemTypes.size()]);
        this.optional = optional;
        if (optional && this.isStatic()) {
            throw new ProvisioningDescriptionException("Static capability cannot be optional: " + this.toString());
        }
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isStatic() {
        return this.elems.length == 1 && this.isElemStatic[0] != false;
    }

    public boolean resolve(CapabilityResolver resolver) throws ProvisioningException {
        for (int i = 0; i < this.elems.length; ++i) {
            if (resolver.resolveElement(this.elems[i], this.isElemStatic[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.optional ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode((Object[])this.isElemStatic);
        result = 31 * result + Arrays.hashCode(this.elems);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapabilitySpec other = (CapabilitySpec)obj;
        if (this.optional != other.optional) {
            return false;
        }
        if (!Arrays.equals((Object[])this.isElemStatic, (Object[])other.isElemStatic)) {
            return false;
        }
        return Arrays.equals(this.elems, other.elems);
    }

    public String toString() {
        if (this.elems.length == 1 && this.isElemStatic[0].booleanValue()) {
            return this.elems[0];
        }
        StringBuilder buf = new StringBuilder();
        if (!this.isElemStatic[0].booleanValue()) {
            buf.append('$');
        }
        buf.append(this.elems[0]);
        for (int i = 1; i < this.elems.length; ++i) {
            buf.append('.');
            if (!this.isElemStatic[i].booleanValue()) {
                buf.append('$');
            }
            buf.append(this.elems[i]);
        }
        return buf.toString();
    }
}

