/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.Stability;

public class FeatureParameterSpec {
    final String name;
    final boolean featureId;
    final boolean nillable;
    final String defaultValue;
    final String type;
    final Stability stability;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(FeatureParameterSpec param) {
        Builder builder = new Builder(param.getName());
        builder.setDefaultValue(param.getDefaultValue());
        if (param.isFeatureId()) {
            builder.setFeatureId();
        }
        if (param.isNillable()) {
            builder.setNillable();
        }
        builder.setType(param.getType());
        return builder;
    }

    public static FeatureParameterSpec create(String name) throws ProvisioningDescriptionException {
        return new FeatureParameterSpec(name, false, false, null, null);
    }

    public static FeatureParameterSpec create(String name, String value) throws ProvisioningDescriptionException {
        return new FeatureParameterSpec(name, false, false, value, null);
    }

    public static FeatureParameterSpec create(String name, boolean nillable) throws ProvisioningDescriptionException {
        return new FeatureParameterSpec(name, false, nillable, null, null);
    }

    public static FeatureParameterSpec createId(String name) throws ProvisioningDescriptionException {
        return new FeatureParameterSpec(name, true, false, null, null);
    }

    public static FeatureParameterSpec create(String name, boolean featureId, boolean nillable, String defaultValue) throws ProvisioningDescriptionException {
        return new FeatureParameterSpec(name, featureId, nillable, defaultValue, null);
    }

    public static FeatureParameterSpec create(String name, boolean featureId, boolean nillable, String defaultValue, Stability stability) throws ProvisioningDescriptionException {
        return new FeatureParameterSpec(name, featureId, nillable, defaultValue, stability);
    }

    private FeatureParameterSpec(String name, boolean featureId, boolean nillable, String defaultValue, Stability stability) throws ProvisioningDescriptionException {
        if (featureId && nillable) {
            throw new ProvisioningDescriptionException("ID parameter " + name + " cannot be nillable.");
        }
        this.name = name;
        this.featureId = featureId;
        this.nillable = nillable;
        this.defaultValue = defaultValue;
        this.type = "String";
        this.stability = stability;
    }

    private FeatureParameterSpec(Builder builder) throws ProvisioningDescriptionException {
        if (builder.featureId && builder.nillable) {
            throw new ProvisioningDescriptionException("ID parameter " + builder.name + " cannot be nillable.");
        }
        this.name = builder.name;
        this.featureId = builder.featureId;
        this.nillable = builder.nillable;
        this.defaultValue = builder.defaultValue;
        this.type = builder.type;
        this.stability = builder.getStability();
    }

    public String getName() {
        return this.name;
    }

    public Stability getStability() {
        return this.stability;
    }

    public boolean isFeatureId() {
        return this.featureId;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.featureId ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nillable ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.stability == null ? 0 : this.stability.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureParameterSpec other = (FeatureParameterSpec)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (this.featureId != other.featureId) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.nillable != other.nillable) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.stability == null ? other.stability != null : !this.stability.equals((Object)other.stability));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.name);
        if (this.defaultValue != null) {
            buf.append('=').append(this.defaultValue);
        }
        if (this.featureId) {
            buf.append(" featureId");
        }
        if (this.nillable) {
            buf.append(" nillable");
        }
        buf.append(' ').append(this.type);
        return buf.append(']').toString();
    }

    public static class Builder {
        private String name;
        private boolean featureId;
        private boolean nillable;
        private String defaultValue;
        private String type = "String";
        private Stability stability;

        private Builder() {
        }

        private Builder(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setStability(Stability stability) {
            this.stability = stability;
            return this;
        }

        public Builder setStability(String stability) {
            if (stability != null) {
                this.stability = Stability.fromString(stability);
            }
            return this;
        }

        public Stability getStability() {
            return this.stability;
        }

        public Builder setFeatureId() {
            this.featureId = true;
            return this;
        }

        public Builder setNillable() {
            this.nillable = true;
            return this;
        }

        public Builder setDefaultValue(String value) {
            this.defaultValue = value;
            return this;
        }

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public FeatureParameterSpec build() throws ProvisioningDescriptionException {
            return new FeatureParameterSpec(this);
        }
    }
}

