/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class FeatureReferenceSpec {
    final String origin;
    final String name;
    final SpecId feature;
    final boolean nillable;
    final boolean include;
    final Map<String, String> mappedParams;

    public static Builder builder(String feature) {
        return new Builder(feature);
    }

    public static FeatureReferenceSpec create(String str) throws ProvisioningDescriptionException {
        return FeatureReferenceSpec.create(str, str, false);
    }

    public static FeatureReferenceSpec create(String str, boolean nillable) throws ProvisioningDescriptionException {
        return FeatureReferenceSpec.create(str, str, nillable);
    }

    public static FeatureReferenceSpec create(String name, String feature, boolean nillable) throws ProvisioningDescriptionException {
        return new FeatureReferenceSpec(null, name, feature, nillable, false, Collections.emptyMap());
    }

    private FeatureReferenceSpec(String origin, String name, String featureSpec, boolean nillable, boolean include, Map<String, String> paramMapping) throws ProvisioningDescriptionException {
        this.origin = origin;
        this.name = name;
        this.feature = SpecId.fromString(featureSpec);
        this.nillable = nillable;
        this.include = include;
        this.mappedParams = CollectionUtils.unmodifiable(paramMapping);
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getName() {
        return this.name;
    }

    public SpecId getFeature() {
        return this.feature;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isInclude() {
        return this.include;
    }

    public boolean hasMappedParams() {
        return !this.mappedParams.isEmpty();
    }

    public int getParamsMapped() {
        return this.mappedParams.size();
    }

    public Map<String, String> getMappedParams() {
        return this.mappedParams;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.feature == null ? 0 : this.feature.hashCode());
        result = 31 * result + (this.include ? 1231 : 1237);
        result = 31 * result + (this.mappedParams == null ? 0 : this.mappedParams.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nillable ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureReferenceSpec other = (FeatureReferenceSpec)obj;
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.feature == null ? other.feature != null : !this.feature.equals(other.feature)) {
            return false;
        }
        if (this.include != other.include) {
            return false;
        }
        if (this.mappedParams == null ? other.mappedParams != null : !this.mappedParams.equals(other.mappedParams)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.nillable == other.nillable;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.name);
        if (this.origin != null) {
            buf.append(" origin=").append(this.origin);
        }
        buf.append(" feature=").append(this.feature);
        if (this.nillable) {
            buf.append(" nillable");
        }
        if (this.include) {
            buf.append(" auto-includes ");
        }
        if (!this.mappedParams.isEmpty()) {
            buf.append(' ');
            StringUtils.append((StringBuilder)buf, this.mappedParams.entrySet());
        }
        return buf.append(']').toString();
    }

    public static class Builder {
        private String origin;
        private final String featureSpec;
        private String name;
        private boolean nillable;
        private boolean include;
        private Map<String, String> mappedParams = Collections.emptyMap();

        private Builder(String spec) {
            this.name = this.featureSpec = spec;
        }

        public Builder setOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setNillable(boolean nillable) {
            this.nillable = nillable;
            return this;
        }

        public Builder setInclude(boolean include) {
            this.include = include;
            return this;
        }

        public Builder mapParam(String localName, String targetName) {
            this.mappedParams = CollectionUtils.put(this.mappedParams, (Object)localName, (Object)targetName);
            return this;
        }

        public FeatureReferenceSpec build() throws ProvisioningDescriptionException {
            return new FeatureReferenceSpec(this.origin, this.name, this.featureSpec, this.nillable, this.include, this.mappedParams);
        }
    }
}

