/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.spec;

import org.jboss.galleon.Stability;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.PackageDepsSpecBuilder;

public class PackageSpec
extends PackageDepsSpec {
    private final String name;
    private final Stability stability;

    public static PackageSpec forName(String name) {
        return new PackageSpec(name);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    protected PackageSpec(String name) {
        this.name = name;
        this.stability = null;
    }

    protected PackageSpec(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.stability = builder.stability;
    }

    public String getName() {
        return this.name;
    }

    public Stability getStability() {
        return this.stability;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageSpec other = (PackageSpec)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[').append(this.name);
        if (this.stability != null) {
            buf.append(" stability=").append((Object)this.stability);
        }
        if (!this.localPkgDeps.isEmpty()) {
            buf.append(" depends on ").append(this.localPkgDeps);
        }
        if (!this.externalPkgDeps.isEmpty()) {
            buf.append(", ").append(this.externalPkgDeps);
        }
        buf.append(']');
        return buf.toString();
    }

    public static class Builder
    extends PackageDepsSpecBuilder<Builder> {
        private String name;
        private Stability stability;

        protected Builder() {
            this((String)null);
        }

        protected Builder(String name) {
            this.name = name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setStability(String stability) {
            if (stability != null) {
                this.stability = Stability.fromString(stability);
            }
            return this;
        }

        public Builder setStability(Stability stability) {
            this.stability = stability;
            return this;
        }

        public PackageSpec build() {
            return new PackageSpec(this);
        }
    }
}

